(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1061551,      24121]
NotebookOptionsPosition[   1053574,      23998]
NotebookOutlinePosition[   1054012,      24015]
CellTagsIndexPosition[   1053969,      24012]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Extract platelet thicknesses and radii from SAXS data", "Title",
 CellChangeTimes->{{3.854421073333592*^9, 3.854421085540827*^9}, {
  3.860138334587551*^9, 3.860138361009327*^9}, {3.889001234807024*^9, 
  3.889001235941153*^9}},ExpressionUUID->"9752d005-1219-465f-8e60-\
2082113917f8"],

Cell[TextData[{
 "This notebook contains the functions to calculate platelet thickness \
distributions from SAXS patterns.  Analysis of individual samples should be \
performed with the notebook ",
 StyleBox["Sample playground.nb",
  FontSlant->"Italic"],
 ".",
 "\nThe current notebook contains functions for the following steps:"
}], "Text",
 CellChangeTimes->{{3.854421073333592*^9, 3.854421085540827*^9}, {
  3.860138334587551*^9, 3.860138477031891*^9}, {3.8601400466828275`*^9, 
  3.8601400869865527`*^9}},ExpressionUUID->"49403409-d150-494f-b081-\
91ce56c28d83"],

Cell["\<\
Process (average, subtract background, merge), export and plot SAXS patterns\
\>", "Item",
 CellChangeTimes->{{3.854421073333592*^9, 3.854421085540827*^9}, {
  3.860138334587551*^9, 
  3.860138515531695*^9}},ExpressionUUID->"c5bb304f-f48f-4254-b437-\
103257a6e918"],

Cell["\<\
Data fitting (calculate (polydisperse) form factor, fit slopes (note that \
intensity fit has been remove for the full form factor incl platelet radius))\
\
\>", "Item",
 CellChangeTimes->{{3.854421073333592*^9, 3.854421085540827*^9}, {
  3.860138334587551*^9, 3.860138516926824*^9}, {3.8601386478729086`*^9, 
  3.860138664129044*^9}, {3.889498683509451*^9, 
  3.8894987072659907`*^9}},ExpressionUUID->"ae041ac8-eae0-47a3-9bd9-\
39e8721130f8"],

Cell[CellGroupData[{

Cell["Import data & setup functions", "Subsubsection",
 CellChangeTimes->{{3.854421073333592*^9, 
  3.854421085540827*^9}},ExpressionUUID->"e214e2f0-1723-47e3-b5e6-\
cc97977345b1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{3.891917782999442*^9, 3.902388336342721*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"6a1e2f36-ed4d-4204-a5ee-f5fb0ba7e773"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"dataPath", "=", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"NotebookDirectory", "[", "]"}], ",", 
       "\"\<2022-08_new_data/Graphene_data_capillaries_ave\>\""}], "}"}], 
     "]"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"dataPath", "=", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
      "\"\<C:/Users/s168562/OneDrive - TU \
Eindhoven/PhD/4_Colloidal_interactions/ESRF/Analysis\>\"", ",", 
       "\"\<2023-07_new_data/Laura-E-series\>\""}], "}"}], "]"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"dataPath", "=", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
      "\"\<C:/Users/s168562/OneDrive - TU \
Eindhoven/PhD/4_Colloidal_interactions/ESRF/Analysis\>\"", ",", 
       "\"\<2023-07_new_data/Lisette\>\""}], "}"}], "]"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"dataPath", "=", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
      "\"\<C:/Users/s168562/OneDrive - TU \
Eindhoven/PhD/4_Colloidal_interactions/ESRF/Analysis\>\"", ",", 
       "\"\<2022-08_new_data/Graphene_data_capillaries_ave\>\""}], "}"}], 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", "dataPath", "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fileNames", "=", 
     RowBox[{"FileNames", "[", 
      RowBox[{
      "RegularExpression", "[", "\"\<\\\\w+eiger2_\\\\d+_ave.h5\>\"", "]"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Length", "[", "fileNames", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.843291109702825*^9, 3.843291129724827*^9}, {
   3.843291167128108*^9, 3.843291185479764*^9}, {3.843291219598308*^9, 
   3.843291222024798*^9}, {3.843291264579451*^9, 3.8432912853783493`*^9}, 
   3.843291319173628*^9, {3.8432913509667788`*^9, 3.843291375972494*^9}, {
   3.843291451400524*^9, 3.843291477387067*^9}, {3.8432915074978447`*^9, 
   3.843291534313446*^9}, {3.843292849473691*^9, 3.843292942812584*^9}, {
   3.8432931554440536`*^9, 3.843293227171956*^9}, {3.843293396905971*^9, 
   3.8432934076677513`*^9}, {3.843293598815793*^9, 3.8432936066087017`*^9}, {
   3.84329364169765*^9, 3.843293676946286*^9}, {3.8432937236680613`*^9, 
   3.843293772333598*^9}, {3.843294707626026*^9, 3.843294724210083*^9}, 
   3.843294770372671*^9, {3.8432948815026712`*^9, 3.8432948844789762`*^9}, {
   3.843295139951911*^9, 3.843295151390843*^9}, {3.843296147653944*^9, 
   3.843296185726388*^9}, {3.843296554609067*^9, 3.843296592633421*^9}, {
   3.843296636066904*^9, 3.843296639883025*^9}, {3.8432966844608583`*^9, 
   3.843296707229643*^9}, {3.843296858083069*^9, 3.843296863457725*^9}, {
   3.843297628887661*^9, 3.8432976613287487`*^9}, {3.8432987537158613`*^9, 
   3.843298773059194*^9}, {3.843298823885009*^9, 3.843298834244919*^9}, {
   3.843299789697318*^9, 3.843299804010457*^9}, {3.852781031022092*^9, 
   3.8527810772744493`*^9}, {3.852781158568071*^9, 3.852781201094832*^9}, {
   3.8527812588052597`*^9, 3.852781283480824*^9}, {3.852781419697466*^9, 
   3.852781430649639*^9}, {3.852781469335927*^9, 3.852781497438036*^9}, {
   3.852781543616589*^9, 3.852781633868348*^9}, {3.8527816651702337`*^9, 
   3.852781748919075*^9}, {3.852781791308778*^9, 3.852781813234481*^9}, {
   3.8527818729040623`*^9, 3.852781874767733*^9}, {3.852782031664762*^9, 
   3.852782067804142*^9}, {3.852782890656323*^9, 3.852782892951396*^9}, 
   3.852784938827908*^9, 3.852785110185223*^9, 3.852785990266891*^9, {
   3.8527861525799932`*^9, 3.852786159462245*^9}, {3.8527862029249353`*^9, 
   3.852786226420244*^9}, {3.853381378758465*^9, 3.853381378945614*^9}, 
   3.853496150649447*^9, {3.8538177863332767`*^9, 3.8538177873549957`*^9}, 
   3.853818176511339*^9, {3.853833034447925*^9, 3.853833034613881*^9}, {
   3.854098398903439*^9, 3.8540983999200363`*^9}, {3.860137189571525*^9, 
   3.860137217401352*^9}, {3.885971180865988*^9, 3.885971188443076*^9}, {
   3.888309497309559*^9, 3.888309616445239*^9}, {3.8894988210904903`*^9, 
   3.889498848750657*^9}, {3.8895036360318656`*^9, 3.889503646388072*^9}, {
   3.8895036902148943`*^9, 3.8895037221118603`*^9}, {3.889503752320318*^9, 
   3.889503789653923*^9}, {3.8895039643492126`*^9, 3.889504039947297*^9}, {
   3.891917778214884*^9, 3.8919177861047926`*^9}, {3.9023883385279427`*^9, 
   3.902388346868284*^9}, {3.903593980932661*^9, 3.903593986453227*^9}, {
   3.9040134706123905`*^9, 3.9040134748645406`*^9}, {3.905228447002757*^9, 
   3.905228456666749*^9}, {3.905851427989444*^9, 3.9058514317194977`*^9}, {
   3.9060126639111533`*^9, 3.906012667210704*^9}, {3.907908382062703*^9, 
   3.9079083881433363`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"bb5b9391-51b5-4754-9301-f8ac33c801e3"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Graphene_data_capillaries_ave\"\>"], "Output",
 CellChangeTimes->{
  3.8895036121748714`*^9, 3.889503647604984*^9, 3.8895037225313816`*^9, 
   3.889503796811266*^9, 3.8895038798579345`*^9, {3.889504042983837*^9, 
   3.8895040528657637`*^9}, 3.889668463822626*^9, 3.890202604224517*^9, 
   3.890976837791486*^9, 3.8914129610421104`*^9, 3.891490100998623*^9, {
   3.8919177898508825`*^9, 3.891917801264139*^9}, 3.8919181780843434`*^9, 
   3.892609275047814*^9, 3.8926269141604004`*^9, 3.9020316096006217`*^9, 
   3.9020343883823447`*^9, 3.9021976227155824`*^9, 3.9023108504241867`*^9, 
   3.902388353662442*^9, 3.9034204506799946`*^9, 3.9035939945873938`*^9, {
   3.9040134559429665`*^9, 3.9040134819929066`*^9}, 3.9040343362221656`*^9, 
   3.904110237476866*^9, 3.9041154147019634`*^9, 3.904116021485797*^9, 
   3.9041163515507517`*^9, 3.904628481939262*^9, 3.904816370801213*^9, 
   3.90481641697658*^9, 3.9058512971122837`*^9, 3.9071451017489185`*^9, 
   3.90790839203039*^9, 3.9079087975926094`*^9},
 CellLabel->"Out[1]=",ExpressionUUID->"8018328c-dcde-4373-a426-c09224a218ee"],

Cell[BoxData["2655"], "Output",
 CellChangeTimes->{
  3.8895036121748714`*^9, 3.889503647604984*^9, 3.8895037225313816`*^9, 
   3.889503796811266*^9, 3.8895038798579345`*^9, {3.889504042983837*^9, 
   3.8895040528657637`*^9}, 3.889668463822626*^9, 3.890202604224517*^9, 
   3.890976837791486*^9, 3.8914129610421104`*^9, 3.891490100998623*^9, {
   3.8919177898508825`*^9, 3.891917801264139*^9}, 3.8919181780843434`*^9, 
   3.892609275047814*^9, 3.8926269141604004`*^9, 3.9020316096006217`*^9, 
   3.9020343883823447`*^9, 3.9021976227155824`*^9, 3.9023108504241867`*^9, 
   3.902388353662442*^9, 3.9034204506799946`*^9, 3.9035939945873938`*^9, {
   3.9040134559429665`*^9, 3.9040134819929066`*^9}, 3.9040343362221656`*^9, 
   3.904110237476866*^9, 3.9041154147019634`*^9, 3.904116021485797*^9, 
   3.9041163515507517`*^9, 3.904628481939262*^9, 3.904816370801213*^9, 
   3.90481641697658*^9, 3.9058512971122837`*^9, 3.9071451017489185`*^9, 
   3.90790839203039*^9, 3.9079087978749547`*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"d2b78cd4-3f7c-4657-93c9-f32189bbed7b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Extract", " ", "all", " ", "file", " ", "names"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetSharedVariable", "[", "j", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"j", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Monitor", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"titles", "=", 
       RowBox[{"ParallelTable", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"j", "++"}], ";", "\[IndentingNewLine]", 
          RowBox[{"title", "=", 
           RowBox[{"StringRiffle", "[", 
            RowBox[{
             RowBox[{"Import", "[", 
              RowBox[{
               RowBox[{"FileNameJoin", "[", 
                RowBox[{"{", 
                 RowBox[{"dataPath", ",", 
                  RowBox[{"fileNames", "[", 
                   RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"{", 
                 RowBox[{
                 "\"\</entry_0000/PyFAI/id02-eiger2-saxs/header/Title\>\"", 
                  ",", "\"\</entry_0000/PyFAI/id02-eiger2-saxs/header/\
SampleDistance\>\""}], "}"}], "}"}]}], "]"}], ",", "\"\<_\>\""}], "]"}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"title", ",", 
            RowBox[{"fileNames", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "[", "fileNames", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "]"}]}], ",", "\[IndentingNewLine]", "j"}], 
     "\[IndentingNewLine]", "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{
  3.852786431189885*^9, {3.852787104362198*^9, 3.852787107216403*^9}, {
   3.8534692703745604`*^9, 3.853469276630739*^9}, {3.853489232693318*^9, 
   3.853489233219405*^9}, {3.853499517183794*^9, 3.853499520757019*^9}, {
   3.8534995809431887`*^9, 3.853499582335005*^9}, {3.860137268641552*^9, 
   3.860137282028754*^9}, 3.903421248426809*^9},
 CellLabel->"In[5]:=",ExpressionUUID->"fc5fd8e9-fab4-4b5c-b2af-d0e7dff8366f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sampleFiles", "=", 
    RowBox[{"GroupBy", "[", 
     RowBox[{"titles", ",", 
      RowBox[{"First", "\[Rule]", "Last"}]}], "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Group", " ", "files", " ", "by", " ", "their", " ", "sample", " ", 
    "name"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Function", " ", "to", " ", "import", " ", "q", " ", "data", " ", "for", 
    " ", "a", " ", "certain", " ", "filename"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"scatteringDataFile", "[", "filename_", "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"filename", ",", "\"\</entry_0000/PyFAI/result_ave/q\>\""}], 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Import", "[", 
        RowBox[{
        "filename", ",", "\"\</entry_0000/PyFAI/result_ave/data\>\""}], "]"}],
        "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "\[Transpose]"}]}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Function", " ", "to", " ", "import", " ", "all", " ", "q", " ", "data", 
    " ", "files", " ", "for", " ", "one", " ", "sample"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"scatteringDataSample", "[", "samplename_", "]"}], ":=", 
    RowBox[{"scatteringDataFile", "/@", 
     RowBox[{"sampleFiles", "[", "samplename", "]"}]}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"scatteringDataSampleAveraged", "[", "samplename_", "]"}], ":=", 
     
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", "1", ",", "1"}], "]"}], "]"}], ",", 
          RowBox[{"MeanAround", "/@", 
           RowBox[{"#", "[", 
            RowBox[{"[", 
             RowBox[{";;", ",", ";;", ",", "2"}], "]"}], "]"}]}]}], "}"}], 
        "\[Transpose]"}], "&"}], "@", 
      RowBox[{"GatherBy", "[", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"scatteringDataSample", "[", "samplename", "]"}], ",", 
          "1"}], "]"}], ",", "First"}], "]"}]}]}], ";"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"scatteringDataSampleAveragedErrors", "[", "samplename_", "]"}], 
     ":=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", "1", ",", "1"}], "]"}], "]"}], ",", 
          RowBox[{"MeanAround", "/@", 
           RowBox[{"#", "[", 
            RowBox[{"[", 
             RowBox[{";;", ",", ";;", ",", "2"}], "]"}], "]"}]}]}], "}"}], 
        "\[Transpose]"}], "&"}], "@", 
      RowBox[{"GatherBy", "[", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"scatteringDataSample", "[", "samplename", "]"}], ",", 
          "1"}], "]"}], ",", "First"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"scatteringDataSampleAveraged", "[", "samplename_", "]"}], ":=", 
    RowBox[{"Mean", "[", 
     RowBox[{
      RowBox[{"GatherBy", "[", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"scatteringDataSample", "[", "samplename", "]"}], ",", 
          "1"}], "]"}], ",", "First"}], "]"}], "\[Transpose]"}], "]"}]}], 
   ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Average", " ", "all", " ", "measurements"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"scatteringDataSampleStdev", "[", "samplename_", "]"}], ":=", 
    RowBox[{"StandardDeviation", "[", 
     RowBox[{
      RowBox[{"GatherBy", "[", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"scatteringDataSample", "[", "samplename", "]"}], ",", 
          "1"}], "]"}], ",", "First"}], "]"}], "\[Transpose]"}], "]"}]}], 
   ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Calculate", " ", "standard", " ", "deviation"}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"scatteringDataSampleAveragedErrors", "[", "samplename_", "]"}], ":=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"scatteringDataSampleAveraged", "[", "samplename", "]"}], 
       "\[Transpose]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Calculate", " ", "average", " ", "and", " ", "stdev", " ", "in", " ", 
       "one", " ", "go"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Around", "@@@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"scatteringDataSampleAveraged", "[", "samplename", "]"}], 
            "\[Transpose]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"scatteringDataSampleStdev", "[", "samplename", "]"}], 
            "\[Transpose]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "\[Transpose]"}], 
       ")"}]}]}], "\[IndentingNewLine]", "}"}], "\[Transpose]"}]}]}], "Input",\

 CellChangeTimes->{{3.852781860752527*^9, 3.852781861400449*^9}, {
   3.852782427495048*^9, 3.852782432845196*^9}, {3.852782490522458*^9, 
   3.8527825233607388`*^9}, 3.852782757511119*^9, {3.8527828983994617`*^9, 
   3.852782923717813*^9}, {3.852783954273013*^9, 3.852783958577043*^9}, {
   3.852784217988599*^9, 3.852784232189209*^9}, {3.852784588124271*^9, 
   3.852784630667053*^9}, 3.8527849493876867`*^9, 3.852786296410307*^9, {
   3.852786445171461*^9, 3.8527864639719877`*^9}, 3.852786739567677*^9, {
   3.852787449131702*^9, 3.852787450514557*^9}, {3.853381975213027*^9, 
   3.853381976205628*^9}, {3.853382404274076*^9, 3.85338240456852*^9}, {
   3.85340333020494*^9, 3.853403408623046*^9}, {3.85340345847932*^9, 
   3.853403507151403*^9}, {3.853409529667601*^9, 3.8534095895008907`*^9}, {
   3.853409682647615*^9, 3.853409684334144*^9}, {3.853410131707053*^9, 
   3.85341017818784*^9}, {3.8538181053955297`*^9, 3.853818151693227*^9}, {
   3.8538238300771923`*^9, 3.853823831444284*^9}, {3.8544235682712183`*^9, 
   3.854423596844871*^9}, {3.8601372879871793`*^9, 3.860137300912186*^9}, {
   3.8601373341336937`*^9, 3.860137513416378*^9}, {3.8601377878238845`*^9, 
   3.860137825471859*^9}, 3.8601381170176554`*^9, 3.8601381527942257`*^9},
 CellLabel->"In[8]:=",ExpressionUUID->"963c927a-6081-41b1-bcc3-11370c5e23da"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Data processing functions", "Subsection"]], \
"Subsubsection",
 CellChangeTimes->{{3.8601381777337103`*^9, 3.8601382230184765`*^9}, {
  3.8601382660907316`*^9, 
  3.8601382667694025`*^9}},ExpressionUUID->"bb1efd3e-4cfd-424b-89f2-\
969547bc7a05"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Function", " ", "to", " ", "subtract", " ", "background"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
     RowBox[{"samplename_", ",", "backgroundname_", ",", "c_"}], "]"}], ":=", 
    
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"scatdata", ",", "backdata"}], "}"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"scatdata", "=", 
        RowBox[{
         RowBox[{"scatteringDataSampleAveraged", "[", "samplename", "]"}], 
         "\[Transpose]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"backdata", "=", 
        RowBox[{
         RowBox[{"scatteringDataSampleAveraged", "[", "backgroundname", "]"}],
          "\[Transpose]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"scatdata", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "==", 
          RowBox[{"backdata", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"Select", "[", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{
            "selecting", " ", "only", " ", "positive", " ", "intensities"}], 
            ";", " ", 
            RowBox[{"change", " ", "if", " ", "desired"}]}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"scatdata", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{
               RowBox[{"scatdata", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "-", 
               RowBox[{"c", " ", 
                RowBox[{"backdata", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}], 
            "\[Transpose]"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Positive", "[", 
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}], "&"}]}], "]"}], ",", 
         "\[IndentingNewLine]", "Null"}], "\[IndentingNewLine]", "]"}]}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Function", " ", "to", " ", "bin", " ", "the", " ", 
     RowBox[{"(", 
      RowBox[{"already", " ", 
       RowBox[{"averaged", "/", "background"}], " ", "subtracted", " ", "if", 
       " ", "desired"}], ")"}], " ", "data"}], "*)"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{
     RowBox[{"binData", "[", 
      RowBox[{"list_", ",", "binning_"}], "]"}], ":=", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"logData", "=", 
          RowBox[{"Log", "[", "list", "]"}]}], ",", "\[IndentingNewLine]", 
         "binnedRawLogData", ",", "\[IndentingNewLine]", "binnedLogData"}], 
        "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"NumberQ", "[", "binning", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"binnedRawLogData", "=", 
           RowBox[{"BinListsBy", "[", 
            RowBox[{"logData", ",", 
             RowBox[{"{", 
              RowBox[{"First", ",", 
               RowBox[{"Min", "[", 
                RowBox[{"logData", "[", 
                 RowBox[{"[", 
                  RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ",", 
               RowBox[{"Max", "[", 
                RowBox[{"logData", "[", 
                 RowBox[{"[", 
                  RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ",", 
               "binning"}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"binnedLogData", "=", 
           RowBox[{
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Mean", "/@", 
               RowBox[{"binnedRawLogData", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", ";;", ",", "1"}], "]"}], "]"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"MeanAround", "/@", 
               RowBox[{"binnedRawLogData", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", ";;", ",", "2"}], "]"}], "]"}]}]}], 
             "\[IndentingNewLine]", "}"}], "\[Transpose]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Return", "[", 
           RowBox[{"Exp", "[", "binnedLogData", "]"}], "]"}], ";"}]}], 
        "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Function", " ", "to", " ", "export", " ", "a", " ", "dataset", " ", 
      "containing", " ", "three", " ", 
      RowBox[{"columns", ":", " ", "q"}]}], ",", " ", 
     RowBox[{"Mean", 
      RowBox[{"(", "I", ")"}], " ", "and", " ", "std", 
      RowBox[{"(", "I", ")"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"exportData", "[", "list_", "]"}], " ", ":=", " ", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"exportlist", " ", "=", " ", 
          RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"datamergedbinned", " ", "=", " ", "list"}]}], 
        "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Do", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"If", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"TrueQ", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Head", "[", 
                RowBox[{"datamergedbinned", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}], "\[Equal]", 
               "Around"}], "||", 
              RowBox[{
               RowBox[{"Head", "[", 
                RowBox[{"datamergedbinned", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}], "\[Equal]", 
               "Real"}]}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"AppendTo", "[", 
             RowBox[{
             "exportlist", ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
              
              RowBox[{"{", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"datamergedbinned", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
                "\[IndentingNewLine]", "\[IndentingNewLine]", 
                RowBox[{"Which", "[", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"TrueQ", "[", 
                   RowBox[{
                    RowBox[{"Head", "[", 
                    RowBox[{"datamergedbinned", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}], "\[Equal]", 
                    "Around"}], "]"}], ",", "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"datamergedbinned", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], "[", 
                   "\"\<Value\>\"", "]"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"TrueQ", "[", 
                   RowBox[{
                    RowBox[{"Head", "[", 
                    RowBox[{"datamergedbinned", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}], "\[Equal]", 
                    "Real"}], "]"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"datamergedbinned", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
                  "\[IndentingNewLine]", "True", ",", "\[IndentingNewLine]", 
                  "Null"}], "\[IndentingNewLine]", "]"}], ",", 
                "\[IndentingNewLine]", "\[IndentingNewLine]", 
                RowBox[{"If", "[", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"Head", "[", "\[IndentingNewLine]", 
                    RowBox[{"datamergedbinned", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], 
                    "\[IndentingNewLine]", "]"}], "\[Equal]", "Around"}], ",",
                   "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"datamergedbinned", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], "[", 
                   "\"\<Uncertainty\>\"", "]"}], ",", "\[IndentingNewLine]", 
                  "0", ",", "\[IndentingNewLine]", "0"}], 
                 "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
               "}"}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]",
            "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"Length", "[", "datamergedbinned", "]"}]}], "}"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", "exportlist", "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Function", " ", "to", " ", "extract", " ", "the", " ", "slopes", " ", 
     "from", " ", "the", " ", "pattern"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"slope", "[", 
      RowBox[{
       RowBox[{"list_", "?", "ListQ"}], ",", 
       RowBox[{"binning_", ":", "False"}]}], "]"}], ":=", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"logData", "=", 
          RowBox[{"Log", "[", "list", "]"}]}], ",", "\[IndentingNewLine]", 
         "binnedRawLogData", ",", "\[IndentingNewLine]", "binnedLogData", ",",
          "\[IndentingNewLine]", "slopesBinned", ",", "\[IndentingNewLine]", 
         "slopes"}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"NumberQ", "[", "binning", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"binnedRawLogData", "=", 
           RowBox[{"BinListsBy", "[", 
            RowBox[{"logData", ",", 
             RowBox[{"{", 
              RowBox[{"First", ",", 
               RowBox[{"Min", "[", 
                RowBox[{"logData", "[", 
                 RowBox[{"[", 
                  RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ",", 
               RowBox[{"Max", "[", 
                RowBox[{"logData", "[", 
                 RowBox[{"[", 
                  RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ",", 
               "binning"}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"binnedLogData", "=", 
           RowBox[{
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Mean", "/@", 
               RowBox[{"binnedRawLogData", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", ";;", ",", "1"}], "]"}], "]"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"MeanAround", "/@", 
               RowBox[{"binnedRawLogData", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", ";;", ",", "2"}], "]"}], "]"}]}]}], 
             "\[IndentingNewLine]", "}"}], "\[Transpose]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"slopesBinned", "=", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Exp", "[", 
               RowBox[{"MovingAverage", "[", 
                RowBox[{
                 RowBox[{"binnedLogData", "[", 
                  RowBox[{"[", 
                   RowBox[{";;", ",", "1"}], "]"}], "]"}], ",", "2"}], "]"}], 
               "]"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "/", 
                 RowBox[{"#", "[", 
                  RowBox[{"[", "1", "]"}], "]"}]}], "&"}], "/@", 
               RowBox[{"Differences", "[", "binnedLogData", "]"}]}]}], "}"}], 
            "\[Transpose]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"Return", "[", "slopesBinned", "]"}], ";"}], ",", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"slopes", "=", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Exp", "[", 
               RowBox[{"MovingAverage", "[", 
                RowBox[{
                 RowBox[{"logData", "[", 
                  RowBox[{"[", 
                   RowBox[{";;", ",", "1"}], "]"}], "]"}], ",", "2"}], "]"}], 
               "]"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "/", 
                 RowBox[{"#", "[", 
                  RowBox[{"[", "1", "]"}], "]"}]}], "&"}], "/@", 
               RowBox[{"Differences", "[", "logData", "]"}]}]}], "}"}], 
            "\[Transpose]"}]}], ";", " ", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{
             RowBox[{
             "Return", " ", "in", " ", "the", " ", "first", " ", "column", 
              " ", "the", " ", "q"}], "-", 
             RowBox[{"value", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "actually", " ", "the", " ", "exponent", " ", "of", " ", 
                  "the", " ", "natural", " ", "log", " ", "of", " ", "the", 
                  " ", "q"}], "-", "value"}], ",", " ", 
                RowBox[{
                 RowBox[{"hence", " ", "the", " ", "q"}], "-", 
                 RowBox[{"value", " ", "itself"}]}]}], ")"}]}]}], ",", " ", 
            RowBox[{"in", " ", "the", " ", "second", " ", 
             RowBox[{
              RowBox[{"column", " ", "[", 
               RowBox[{
                RowBox[{"ln", 
                 RowBox[{"(", 
                  RowBox[{"I", 
                   RowBox[{"(", 
                    RowBox[{"q", "+", "1"}], ")"}]}], ")"}]}], "-", 
                RowBox[{"ln", 
                 RowBox[{"(", 
                  RowBox[{"I", 
                   RowBox[{"(", "q", ")"}]}], ")"}]}]}], "]"}], "/", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"ln", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "1"}], ")"}]}], "-", 
                RowBox[{"ln", 
                 RowBox[{"(", "q", ")"}]}]}], "]"}]}], " ", 
             RowBox[{"(", 
              RowBox[{
              "effectively", " ", "the", " ", "slope", " ", "in", " ", "each",
                " ", "point"}], ")"}]}]}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"Return", "[", "slopes", "]"}], ";"}]}], 
        "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"BinListsBy", "[", 
     RowBox[{"data_List", ",", " ", "binspecs__List"}], "]"}], " ", ":=", " ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "fs", ",", " ", "idata", ",", " ", "len", ",", " ", "out", ",", " ", 
        "dims"}], "}"}], ",", " ", 
      RowBox[{
       RowBox[{"len", " ", "=", " ", 
        RowBox[{"Length", "[", "data", "]"}]}], ";", " ", 
       RowBox[{"fs", " ", "=", " ", 
        RowBox[{"{", "binspecs", "}"}]}], ";", " ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"AllTrue", "[", 
          RowBox[{"fs", ",", " ", 
           RowBox[{
            RowBox[{"MatchQ", "[", 
             RowBox[{"#1", ",", " ", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"_", ",", " ", 
                 RowBox[{"_", "?", "NumericQ"}], ",", " ", 
                 RowBox[{"_", "?", "NumericQ"}]}], "}"}], " ", "|", " ", 
               RowBox[{"{", 
                RowBox[{"_", ",", " ", 
                 RowBox[{"_", "?", "NumericQ"}], ",", " ", 
                 RowBox[{"_", "?", "NumericQ"}], ",", " ", 
                 RowBox[{"_", "?", "NumericQ"}]}], "}"}]}]}], "]"}], " ", 
            "&"}]}], " ", "]"}], ",", " ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"len", " ", ">", " ", "0"}], ",", " ", 
           RowBox[{
            RowBox[{"idata", " ", "=", " ", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"f", " ", "/@", " ", "data"}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"f", ",", " ", 
                 RowBox[{"fs", "[", 
                  RowBox[{"[", 
                   RowBox[{"All", ",", "1"}], "]"}], "]"}]}], "}"}]}], 
              "]"}]}], ";", " ", 
            RowBox[{"AppendTo", "[", 
             RowBox[{"idata", ",", " ", 
              RowBox[{"Range", "[", "len", "]"}]}], "]"}], ";", " ", 
            RowBox[{"out", " ", "=", " ", 
             RowBox[{"BinLists", "[", 
              RowBox[{
               RowBox[{"Transpose", "[", "idata", "]"}], ",", " ", 
               RowBox[{"Sequence", " ", "@@", " ", 
                RowBox[{"Rest", " ", "/@", " ", "fs"}]}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"0", ",", " ", 
                 RowBox[{"len", " ", "+", " ", "1"}], ",", " ", 
                 RowBox[{"len", " ", "+", " ", "1"}]}], "}"}]}], "]"}]}], ";",
             " ", 
            RowBox[{"out", " ", "=", " ", 
             RowBox[{"out", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"Sequence", " ", "@@", " ", 
                 RowBox[{"ConstantArray", "[", 
                  RowBox[{"All", ",", " ", 
                   RowBox[{"Length", "[", "fs", "]"}]}], "]"}]}], ",", "1", 
                ",", "All", ",", 
                RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";", " ", 
            RowBox[{"Map", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"data", "[", 
                RowBox[{"[", "#1", "]"}], "]"}], " ", "&"}], " ", ",", " ", 
              "out", ",", " ", 
              RowBox[{"{", 
               RowBox[{"Length", "[", "fs", "]"}], "}"}]}], "]"}]}], ",", " ", 
           RowBox[{
            RowBox[{"dims", " ", "=", " ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"Length", "[", 
                  RowBox[{"Range", " ", "@@", " ", "#1"}], "]"}], " ", "-", 
                 " ", "1"}], " ", "&"}], " ", ")"}], " ", "/@", " ", 
              RowBox[{"Rest", " ", "/@", " ", "fs"}]}]}], ";", " ", 
            RowBox[{"ConstantArray", "[", 
             RowBox[{
              RowBox[{"{", "}"}], ",", " ", "dims"}], "]"}]}]}], "]"}], ",", 
         " ", 
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"BinListsBy", "::", "invalidspec"}], ",", " ", "fs"}], 
          "]"}]}], "]"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BinListsBy", "::", "invalidspec"}], " ", "=", " ", 
     "\"\<One or more of your binning specifications `1` is incorrect\
\[Ellipsis]\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Sort", "[", 
    RowBox[{"Keys", "[", "sampleFiles", "]"}], "]"}], "\[IndentingNewLine]", 
   "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Merging", " ", "data", " ", "sets"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mergeData", "[", 
     RowBox[{
      RowBox[{"dataset1_", "?", "ListQ"}], ",", 
      RowBox[{"dataset2_", "?", "ListQ"}]}], "]"}], ":=", 
    RowBox[{"Block", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"data1", "=", 
         RowBox[{"Log", "[", "dataset1", "]"}]}], ",", "\[IndentingNewLine]", 
        
        RowBox[{"data2", "=", 
         RowBox[{"Log", "[", "dataset2", "]"}]}], ",", "\[IndentingNewLine]", 
        "overlapRange", ",", "\[IndentingNewLine]", "overlap1", ",", 
        "\[IndentingNewLine]", "overlap2", ",", "\[IndentingNewLine]", 
        "overlappos", ",", "\[IndentingNewLine]", "scale", ",", 
        "\[IndentingNewLine]", "cutoff", ",", "\[IndentingNewLine]", 
        "cutoffno", ",", "\[IndentingNewLine]", "movingstdev"}], 
       "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"overlapRange", "=", "\[IndentingNewLine]", 
        RowBox[{"Which", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Min", "[", 
             RowBox[{"data2", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], "<", 
            RowBox[{"Max", "[", 
             RowBox[{"data1", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "&&", 
           RowBox[{
            RowBox[{"Max", "[", 
             RowBox[{"data2", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ">", 
            RowBox[{"Max", "[", 
             RowBox[{"data1", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "&&", 
           RowBox[{
            RowBox[{"Min", "[", 
             RowBox[{"data2", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ">", 
            RowBox[{"Min", "[", 
             RowBox[{"data1", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Min", "[", 
             RowBox[{"data2", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ",", 
            RowBox[{"Max", "[", 
             RowBox[{"data1", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Min", "[", 
               RowBox[{"data1", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], "<", 
              RowBox[{"Max", "[", 
               RowBox[{"data2", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "&&", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Max", "[", 
               RowBox[{"data2", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], "<", 
              RowBox[{"Max", "[", 
               RowBox[{"data1", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "&&", 
             RowBox[{
              RowBox[{"Min", "[", 
               RowBox[{"data2", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], "<", 
              RowBox[{"Min", "[", 
               RowBox[{"data1", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}]}], 
            "\[IndentingNewLine]", ","}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Min", "[", 
               RowBox[{"data1", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ",", 
              RowBox[{"Max", "[", 
               RowBox[{"data2", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "}"}], 
            ","}], "*)"}], "\[IndentingNewLine]", "True", ",", 
          "\[IndentingNewLine]", 
          RowBox[{
          "Return", "[", "\"\<Error, no overlap, wrong order?\>\"", "]"}]}], 
         "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"overlap1", "=", 
        RowBox[{"Select", "[", 
         RowBox[{"data1", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"overlapRange", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<", 
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<", 
            RowBox[{"overlapRange", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"overlap2", "=", 
        RowBox[{"Select", "[", 
         RowBox[{"data2", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"overlapRange", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<", 
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<", 
            RowBox[{"overlapRange", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"overlappos", "=", 
        RowBox[{"Flatten", "[", 
         RowBox[{"Nearest", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"overlap1", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "1"}], "]"}], "]"}], "\[Rule]", 
            RowBox[{"Range", "[", 
             RowBox[{"Length", "[", "overlap1", "]"}], "]"}]}], ",", 
           RowBox[{"overlap2", "[", 
            RowBox[{"[", 
             RowBox[{";;", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"scale", "=", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Exp", "[", "c", "]"}], "/.", 
          RowBox[{
           RowBox[{"FindMinimum", "[", 
            RowBox[{
             RowBox[{"Norm", "[", 
              RowBox[{
               RowBox[{"overlap1", "[", 
                RowBox[{"[", 
                 RowBox[{"overlappos", ",", "2"}], "]"}], "]"}], "-", " ", 
               RowBox[{"overlap2", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "2"}], "]"}], "]"}], "-", "c"}], "]"}], 
             ",", "c"}], "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"movingstdev", "=", 
        RowBox[{"MovingAverage", "[", 
         RowBox[{
          RowBox[{"MovingMap", "[", 
           RowBox[{"StandardDeviation", ",", 
            RowBox[{
             RowBox[{"overlap1", "[", 
              RowBox[{"[", 
               RowBox[{"overlappos", ",", "2"}], "]"}], "]"}], "-", " ", 
             RowBox[{"overlap2", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "2"}], "]"}], "]"}], "+", 
             RowBox[{"Log", "[", "scale", "]"}]}], ",", "10"}], "]"}], ",", 
          "10"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"cutoffno", "=", 
        RowBox[{"First", "[", 
         RowBox[{"First", "[", 
          RowBox[{"Position", "[", 
           RowBox[{"movingstdev", ",", 
            RowBox[{"_", "?", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"#", ">", "0.01"}], "&"}], ")"}]}]}], "]"}], "]"}], 
         "]"}]}], ";", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"was", " ", "0.1"}], ",", " ", 
         RowBox[{
         "but", " ", "gave", " ", "error", " ", "in", " ", "case", " ", "of", 
          " ", "already", " ", 
          RowBox[{"(", "almost", ")"}], " ", "overlapping", " ", "curves"}]}],
         " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"cutoff", "=", 
        RowBox[{"Exp", "[", 
         RowBox[{"overlap2", "[", 
          RowBox[{"[", 
           RowBox[{"cutoffno", ",", "1"}], "]"}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "\[IndentingNewLine]", 
        RowBox[{"Sort", "[", "\[IndentingNewLine]", 
         RowBox[{"Join", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{"dataset1", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "<", "cutoff"}], "&"}]}], 
            "]"}], ",", 
           RowBox[{"dataset2", ".", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "scale"}], "}"}]}], "}"}]}]}], 
          "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}], 
        "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
     "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.852781860752527*^9, 3.852781861400449*^9}, {
   3.852782427495048*^9, 3.852782432845196*^9}, {3.852782490522458*^9, 
   3.8527825233607388`*^9}, 3.852782757511119*^9, {3.8527828983994617`*^9, 
   3.852782923717813*^9}, {3.852783954273013*^9, 3.852783958577043*^9}, {
   3.852784217988599*^9, 3.852784232189209*^9}, {3.852784588124271*^9, 
   3.852784630667053*^9}, 3.8527849493876867`*^9, 3.852786296410307*^9, {
   3.852786445171461*^9, 3.8527864639719877`*^9}, 3.852786739567677*^9, {
   3.852787449131702*^9, 3.852787450514557*^9}, {3.853381975213027*^9, 
   3.853381976205628*^9}, {3.853382404274076*^9, 3.85338240456852*^9}, {
   3.85340333020494*^9, 3.853403408623046*^9}, {3.85340345847932*^9, 
   3.853403507151403*^9}, {3.853409529667601*^9, 3.8534095895008907`*^9}, {
   3.853409682647615*^9, 3.853409684334144*^9}, {3.853410131707053*^9, 
   3.85341017818784*^9}, {3.8538181053955297`*^9, 3.853818151693227*^9}, {
   3.8538238300771923`*^9, 3.853823831444284*^9}, {3.8544235682712183`*^9, 
   3.854423596844871*^9}, {3.8601372879871793`*^9, 3.860137300912186*^9}, {
   3.8601373341336937`*^9, 3.860137513416378*^9}, {3.8601377878238845`*^9, 
   3.860137825471859*^9}, 3.8601381170176554`*^9, {3.8601381527942257`*^9, 
   3.8601381554698157`*^9}, 3.860139314345042*^9, {3.8601396136069946`*^9, 
   3.860139637809037*^9}, {3.860140274802857*^9, 3.8601402881469436`*^9}, {
   3.8601403266498127`*^9, 3.860140345820403*^9}, {3.860140410589032*^9, 
   3.860140446255523*^9}, {3.8601404885987186`*^9, 3.8601405253716545`*^9}, {
   3.8601405888823967`*^9, 3.8601406208542633`*^9}, {3.860140651384527*^9, 
   3.86014076017659*^9}, {3.8601408369383373`*^9, 3.8601408546914597`*^9}, {
   3.8601412665787563`*^9, 3.860141297881263*^9}, 3.8629073718138065`*^9, {
   3.8636846731243887`*^9, 3.863684721178178*^9}, {3.8636849961195316`*^9, 
   3.8636850169326954`*^9}, {3.863685081135563*^9, 3.8636851178496304`*^9}, {
   3.863685275732274*^9, 3.863685280648721*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"f2858960-ee9b-434f-ab6f-b0967ca77d38"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"BG18_10.0042\"\>", ",", "\<\"BG18_1.504\"\>", 
   ",", "\<\"BG18_30.7138\"\>", ",", "\<\"BG19_10.004\"\>", 
   ",", "\<\"BG19_30.7138\"\>", ",", "\<\"BG20_10.0042\"\>", 
   ",", "\<\"BG20_1.504\"\>", ",", "\<\"BG20_30.7138\"\>", 
   ",", "\<\"BG21_10.0042\"\>", ",", "\<\"BG21_1.504\"\>", 
   ",", "\<\"BG21_30.7138\"\>", ",", "\<\"BG22_10.0042\"\>", 
   ",", "\<\"BG22_1.504\"\>", ",", "\<\"BG22_30.7138\"\>", 
   ",", "\<\"BG23_10.0042\"\>", ",", "\<\"BG23_1.504\"\>", 
   ",", "\<\"BG23_30.7138\"\>", ",", "\<\"BG24_10.0042\"\>", 
   ",", "\<\"BG24_1.504\"\>", ",", "\<\"BG24_30.7138\"\>", 
   ",", "\<\"BG25_10.0042\"\>", ",", "\<\"BG25_1.504\"\>", 
   ",", "\<\"BG25_30.7138\"\>", ",", "\<\"BG26_10.0042\"\>", 
   ",", "\<\"BG26_1.504\"\>", ",", "\<\"BG26_30.7138\"\>", 
   ",", "\<\"BG31_10.0042\"\>", ",", "\<\"BG31_1.504\"\>", 
   ",", "\<\"BG31_30.7138\"\>", ",", "\<\"BG34_10.0042\"\>", 
   ",", "\<\"BG34_1.504\"\>", ",", "\<\"BG34_30.7138\"\>", 
   ",", "\<\"BG35_10.0042\"\>", ",", "\<\"BG35_1.504\"\>", 
   ",", "\<\"BG35_30.7138\"\>", ",", "\<\"BG36_10.0042\"\>", 
   ",", "\<\"BG36_1.504\"\>", ",", "\<\"BG36_30.7138\"\>", 
   ",", "\<\"BG37_10.0042\"\>", ",", "\<\"BG37_1.504\"\>", 
   ",", "\<\"BG37_30.7138\"\>", ",", "\<\"BG38_10.0042\"\>", 
   ",", "\<\"BG38_1.504\"\>", ",", "\<\"BG38_30.7138\"\>", 
   ",", "\<\"C10_10.0042\"\>", ",", "\<\"C10_1.504\"\>", 
   ",", "\<\"C10_30.7138\"\>", ",", "\<\"C1_10.004\"\>", 
   ",", "\<\"C11_10.0042\"\>", ",", "\<\"C11_1.504\"\>", 
   ",", "\<\"C11_2_10.0042\"\>", ",", "\<\"C11_2_1.504\"\>", 
   ",", "\<\"C11_2_30.7138\"\>", ",", "\<\"C11_30.7138\"\>", 
   ",", "\<\"C1_1.504\"\>", ",", "\<\"C12_10.0042\"\>", 
   ",", "\<\"C12_1.504\"\>", ",", "\<\"C12_30.7138\"\>", 
   ",", "\<\"C1_30.7138\"\>", ",", "\<\"C13_10.0042\"\>", 
   ",", "\<\"C13_1.504\"\>", ",", "\<\"C13_30.7138\"\>", 
   ",", "\<\"C14_10.0042\"\>", ",", "\<\"C14_1.504\"\>", 
   ",", "\<\"C14_30.7138\"\>", ",", "\<\"C15_10.0042\"\>", 
   ",", "\<\"C15_1.504\"\>", ",", "\<\"C15_30.7138\"\>", 
   ",", "\<\"C16_10.0042\"\>", ",", "\<\"C16_1.504\"\>", 
   ",", "\<\"C16_30.7138\"\>", ",", "\<\"C17_10.0042\"\>", 
   ",", "\<\"C17_1.504\"\>", ",", "\<\"C17_30.7138\"\>", 
   ",", "\<\"C18_10.0042\"\>", ",", "\<\"C18_1.504\"\>", 
   ",", "\<\"C18_30.7138\"\>", ",", "\<\"C19_10.0042\"\>", 
   ",", "\<\"C19_1.504\"\>", ",", "\<\"C19_30.7138\"\>", 
   ",", "\<\"C20_10.0042\"\>", ",", "\<\"C20_1.504\"\>", 
   ",", "\<\"C20_30.7138\"\>", ",", "\<\"C2_10.0042\"\>", 
   ",", "\<\"C21_10.0042\"\>", ",", "\<\"C21_1.504\"\>", 
   ",", "\<\"C21_30.7138\"\>", ",", "\<\"C2_1.504\"\>", 
   ",", "\<\"C22_10.0042\"\>", ",", "\<\"C22_1.504\"\>", 
   ",", "\<\"C22_30.7138\"\>", ",", "\<\"C2_30.7138\"\>", 
   ",", "\<\"C23_10.0042\"\>", ",", "\<\"C23_1.504\"\>", 
   ",", "\<\"C23_30.7138\"\>", ",", "\<\"C24_10.0042\"\>", 
   ",", "\<\"C24_1.504\"\>", ",", "\<\"C24_30.7138\"\>", 
   ",", "\<\"C25_10.0042\"\>", ",", "\<\"C25_1.504\"\>", 
   ",", "\<\"C25_30.7138\"\>", ",", "\<\"C26_10.0042\"\>", 
   ",", "\<\"C26_1.504\"\>", ",", "\<\"C26_30.7138\"\>", 
   ",", "\<\"C27_10.0042\"\>", ",", "\<\"C27_1.504\"\>", 
   ",", "\<\"C27_30.7138\"\>", ",", "\<\"C28_10.0042\"\>", 
   ",", "\<\"C28_1.504\"\>", ",", "\<\"C28_30.7138\"\>", 
   ",", "\<\"C29_10.0042\"\>", ",", "\<\"C29_1.504\"\>", 
   ",", "\<\"C29_30.7138\"\>", ",", "\<\"C30_10.0042\"\>", 
   ",", "\<\"C30_1.504\"\>", ",", "\<\"C30_30.7138\"\>", 
   ",", "\<\"C3_10.0042\"\>", ",", "\<\"C31_10.0042\"\>", 
   ",", "\<\"C31_1.504\"\>", ",", "\<\"C31_30.7138\"\>", 
   ",", "\<\"C3_1.504\"\>", ",", "\<\"C32_10.0042\"\>", 
   ",", "\<\"C32_1.504\"\>", ",", "\<\"C32_30.7138\"\>", 
   ",", "\<\"C3_30.7138\"\>", ",", "\<\"C33_10.0042\"\>", 
   ",", "\<\"C33_1.504\"\>", ",", "\<\"C33_30.7138\"\>", 
   ",", "\<\"C4_10.0042\"\>", ",", "\<\"C4_1.504\"\>", 
   ",", "\<\"C4_30.7138\"\>", ",", "\<\"C5_10.0042\"\>", 
   ",", "\<\"C5_1.504\"\>", ",", "\<\"C5_30.7138\"\>", 
   ",", "\<\"C8_10.0042\"\>", ",", "\<\"C8_1.504\"\>", 
   ",", "\<\"C8_30.7138\"\>", ",", "\<\"C9_10.0042\"\>", 
   ",", "\<\"C9_1.504\"\>", ",", "\<\"C9_30.7138\"\>", 
   ",", "\<\"Empty_Cap_10.0042\"\>", ",", "\<\"Empty_Cap_1.504\"\>", 
   ",", "\<\"Empty_Cap_30.7138\"\>"}], "}"}]], "Output",
 CellChangeTimes->{{3.843291116410307*^9, 3.843291130190617*^9}, {
   3.8432911719097652`*^9, 3.843291185978409*^9}, 3.843291220560841*^9, {
   3.8432912704296637`*^9, 3.84329127392964*^9}, 3.843291320135066*^9, {
   3.8432913518879747`*^9, 3.8432913767025137`*^9}, {3.84329145300187*^9, 
   3.843291477899846*^9}, {3.843291512572294*^9, 3.843291534673026*^9}, 
   3.8432928114247313`*^9, 3.843292945133399*^9, {3.843293186383741*^9, 
   3.843293193473956*^9}, 3.843293608109157*^9, 3.843293645515916*^9, {
   3.843293716052813*^9, 3.843293730759082*^9}, {3.843293761080804*^9, 
   3.843293772865118*^9}, 3.8432938713954144`*^9, {3.84329471860441*^9, 
   3.8432947251573477`*^9}, 3.843294771162959*^9, 3.843294885917644*^9, 
   3.843295151895554*^9, 3.8432956501750383`*^9, 3.843296152599977*^9, {
   3.843296189871492*^9, 3.843296191243095*^9}, 3.84329659605822*^9, 
   3.843296864247712*^9, 3.843297654343287*^9, 3.843297684687933*^9, 
   3.843298780405675*^9, 3.8432988461417847`*^9, 3.843299816472809*^9, 
   3.852779404882422*^9, {3.852782926379023*^9, 3.852782939958962*^9}, 
   3.852783082585239*^9, 3.85278423842143*^9, 3.852784635998056*^9, 
   3.852784774684959*^9, 3.85278495816325*^9, 3.852785644257989*^9, 
   3.852786584046872*^9, 3.852787231457491*^9, 3.8527874512893887`*^9, 
   3.8528624946437807`*^9, 3.8533813666181393`*^9, 3.853381473051558*^9, 
   3.853382002859495*^9, {3.853382366117324*^9, 3.8533824068816853`*^9}, 
   3.853382447973559*^9, 3.853402237496472*^9, {3.8534035050061913`*^9, 
   3.853403520153386*^9}, {3.853409576568863*^9, 3.853409590687502*^9}, 
   3.853409686569212*^9, 3.853410179540357*^9, 3.85346909235686*^9, {
   3.853496221708645*^9, 3.853496230454815*^9}, 3.8534962722710114`*^9, 
   3.8534995714970713`*^9, 3.8534996217654676`*^9, {3.8534998537977457`*^9, 
   3.853499861198127*^9}, 3.853817842905547*^9, 3.8538182330499973`*^9, 
   3.853823854615374*^9, 3.853824682278778*^9, 3.8538248698359203`*^9, 
   3.8538330740724907`*^9, 3.853836452527369*^9, 3.853838538520102*^9, 
   3.854072553798176*^9, 3.854091674337735*^9, 3.854098459639974*^9, 
   3.8544207575313673`*^9, {3.854423578230679*^9, 3.854423602648951*^9}, 
   3.8601380332758555`*^9, 3.8601397073699045`*^9, 3.8601408681378775`*^9, 
   3.860141165553254*^9, 3.8617630814145107`*^9, 3.8617632495409374`*^9, 
   3.86194321925034*^9, 3.861950293500869*^9, 3.862109428120537*^9, 
   3.862204577976136*^9, 3.8859712433884926`*^9, 3.8859717023665004`*^9, 
   3.885973538318736*^9, 3.8871822213001337`*^9, 3.888309647401424*^9, 
   3.888309685383727*^9, 3.8883100772164288`*^9, 3.889001634921618*^9, 
   3.889060229645113*^9, 3.889064545330427*^9, 3.88908010527439*^9, 
   3.88908177519516*^9, 3.889082725590596*^9, 3.8890843099944553`*^9, 
   3.889498714652341*^9, 3.889499954222128*^9, 3.8895040850259047`*^9, 
   3.88966850980521*^9, 3.890202669873102*^9, 3.89097689186923*^9, 
   3.8914131817881813`*^9, 3.8914901650050025`*^9, 3.8919178772682314`*^9, 
   3.891918256701417*^9, 3.8926093273920903`*^9, 3.892626965833712*^9, 
   3.902034976330225*^9, 3.9021976646180515`*^9, 3.9023109317620115`*^9, 
   3.903420470169649*^9, 3.904013505318366*^9, 3.9040343603475456`*^9, 
   3.9041102586408815`*^9, 3.9041154307658567`*^9, 3.904116044177828*^9, 
   3.9041163772241936`*^9, 3.904184035433017*^9, 3.9046285193679733`*^9, 
   3.9058513203852787`*^9, 3.906016931953811*^9, 3.907145134293648*^9, 
   3.907908632553444*^9, 3.9079088498452835`*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"3760eb02-cf62-4dd3-aede-4fcdd3f5dcd3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data fitting commands", "Subsection",
 CellChangeTimes->{{3.853833173909893*^9, 3.85383317510979*^9}, {
  3.854423364858252*^9, 
  3.854423369840681*^9}},ExpressionUUID->"9ecbbbc5-8b8f-4847-b220-\
8094510e4a4e"],

Cell["\<\
importing (or calculating -- which is very slow --, then saving) a table with \
all scattering patterns for a range of q, l, and r\
\>", "Text",
 CellChangeTimes->{{3.889001751397065*^9, 3.8890017945493183`*^9}, {
  3.8894989004771748`*^9, 
  3.8894989080000873`*^9}},ExpressionUUID->"1226fcdb-2e55-460d-933b-\
f363aeb6389f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"qmin", "=", 
    RowBox[{"-", "3"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"log", " ", "scale", " ", 
    RowBox[{"10", "^", "x"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"qmax", "=", "1"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"log", " ", "scale", " ", 
    RowBox[{"10", "^", "x"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"qstep", "=", "0.02"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"qlist", "=", 
    RowBox[{"10", "^", 
     RowBox[{"Range", "[", 
      RowBox[{"qmin", ",", "qmax", ",", "qstep"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"qlistslope", "=", 
    RowBox[{"Exp", "[", 
     RowBox[{"MovingAverage", "[", 
      RowBox[{
       RowBox[{"Log", "[", "qlist", "]"}], ",", "2"}], "]"}], "]"}]}], ";"}], 
  " ", 
  RowBox[{"(*", 
   RowBox[{"slope", "-", 
    RowBox[{
    "fitting", " ", "is", " ", "done", " ", "using", " ", "log", " ", 
     "scale"}]}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lengthmin", "=", 
    RowBox[{"-", "1"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"log", " ", "scale", " ", 
    RowBox[{"10", "^", "x"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lengthmax", "=", "3"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"log", " ", "scale", " ", 
    RowBox[{"10", "^", "x"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lengthstep", "=", "0.02"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lengths", "=", 
    RowBox[{"10", "^", 
     RowBox[{"Range", "[", 
      RowBox[{"lengthmin", ",", "lengthmax", ",", "lengthstep"}], "]"}]}]}], 
   ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"radiusmin", "=", "1"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"log", " ", "scale", " ", 
    RowBox[{"10", "^", "x"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"radiusmax", "=", "4"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"log", " ", "scale", " ", 
    RowBox[{"10", "^", "x"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"radiusstep", "=", "0.02"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"radii", "=", 
    RowBox[{"10", "^", 
     RowBox[{"Range", "[", 
      RowBox[{"radiusmin", ",", "radiusmax", ",", "radiusstep"}], "]"}]}]}], 
   ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Length", "[", "lengths", "]"}], "*", 
   RowBox[{"Length", "[", "radii", "]"}]}], " ", 
  RowBox[{"(*", 
   RowBox[{
   "number", " ", "of", " ", "combinations", " ", "of", " ", "L", " ", "and", 
    " ", "R"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Define", " ", "a", " ", "form", " ", "factor", " ", "for", " ", "disk", 
    " ", "with", " ", "radius", " ", "L", " ", "and", " ", "length", " ", "R",
     " ", 
    RowBox[{"(", 
     RowBox[{"Pedersen", " ", "1997"}], ")"}]}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"P11", "[", 
     RowBox[{"q_", ",", "R_", ",", "L_"}], "]"}], ":=", 
    RowBox[{"Quiet", "[", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"2", " ", 
             RowBox[{"BesselJ", "[", 
              RowBox[{"1", ",", 
               RowBox[{"q", " ", "R", " ", 
                RowBox[{"Sin", "[", "\[Alpha]", "]"}]}]}], "]"}]}], 
            RowBox[{"q", " ", "R", " ", 
             RowBox[{"Sin", "[", "\[Alpha]", "]"}]}]], " ", 
           FractionBox[
            RowBox[{"Sin", "[", 
             FractionBox[
              RowBox[{"q", " ", "L", " ", 
               RowBox[{"Cos", "[", "\[Alpha]", "]"}]}], "2"], "]"}], 
            FractionBox[
             RowBox[{"q", " ", "L", " ", 
              RowBox[{"Cos", "[", "\[Alpha]", "]"}]}], "2"]]}], ")"}], "2"], 
        RowBox[{"Sin", "[", "\[Alpha]", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Alpha]", ",", "0", ",", 
         FractionBox["\[Pi]", "2"]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"filename", "=", 
    RowBox[{"\"\<double polydisp data \>\"", "<>", 
     RowBox[{"ToString", "[", 
      RowBox[{"Hash", "[", 
       RowBox[{"{", 
        RowBox[{"qlist", ",", "lengths", ",", "radii"}], "}"}], "]"}], "]"}], 
     "<>", "\"\<.mx\>\""}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Unfortunately", " ", "looks", " ", "like", " ", "this", " ", "hash", " ",
      "code", " ", "is", " ", "computer", " ", "specific"}], ",", " ", 
    RowBox[{
    "so", " ", "might", " ", "need", " ", "to", " ", "change", " ", "the", 
     " ", "file", " ", "name", " ", "of", " ", "the", " ", "existing", " ", 
     "table", " ", "to", " ", "this", " ", "name", " ", "if", " ", "you", " ",
      "want", " ", "to", " ", "reuse", " ", 
     RowBox[{"it", "."}]}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"filename", "=", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"NotebookDirectory", "[", "]"}], ",", "filename"}], "}"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"filename", "=", 
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", 
        "\"\<double polydisp data 8767617112876749221.mx\>\""}], "}"}], 
      "]"}]}], ";"}], " ", "*)"}], 
  RowBox[{"(*", " ", 
   RowBox[{
   "in", " ", "case", " ", "you", " ", "want", " ", "to", " ", "manually", 
    " ", "enter", " ", "the", " ", "file", " ", "name", " ", "for", " ", 
    "the", " ", "hash", " ", "code", " ", "is", " ", "different", " ", "when",
     " ", "generated", " ", "on", " ", "different", " ", "computers"}], 
   "*)"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"If", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FileExistsQ", "[", "filename", "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dataAllLengths", "=", 
      RowBox[{"<<", 
       RowBox[{"(", "filename", ")"}]}]}], ";"}], ",", "\[IndentingNewLine]", 
    
    RowBox[{
     RowBox[{"SetSharedVariable", "[", "j", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"j", "=", "0"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Monitor", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"dataAllLengths", "=", 
         RowBox[{"Quiet", "[", "\[IndentingNewLine]", 
          RowBox[{"ParallelTable", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Table", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{"j", "++"}], ";", "\[IndentingNewLine]", 
               RowBox[{"P11", "[", 
                RowBox[{"qlist", ",", "radius", ",", "length"}], "]"}]}], ",",
               "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"length", ",", "lengths"}], "}"}]}], 
             "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"radius", ",", "radii"}], "}"}]}], "\[IndentingNewLine]",
            "]"}], "\[IndentingNewLine]", "]"}]}], ";"}], ",", 
       "\[IndentingNewLine]", "j"}], "\[IndentingNewLine]", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"dataAllLengths", ">>", 
      RowBox[{"(", "filename", ")"}]}]}]}], "\[IndentingNewLine]", "]"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "definition", " ", "of", " ", "probability", " ", "density", " ", 
    "function", " ", "and", " ", "function", " ", "to", " ", "calculate", " ",
     "intensities", " ", "with", " ", "both", " ", "L", " ", "and", " ", "R", 
    " ", 
    RowBox[{"unknown", "."}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"probfunc", "[", 
    RowBox[{
    "\[Mu]l_", ",", "\[Sigma]l_", ",", "\[Mu]r_", ",", "\[Sigma]r_", ",", 
     "l_", ",", "r_"}], "]"}], "=", "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"LogMultinormalDistribution", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\[Mu]l", ",", "\[Mu]r"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SuperscriptBox["\[Sigma]l", "2"], ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             SuperscriptBox["\[Sigma]r", "2"]}], "}"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "r"}], "}"}]}], "]"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"l", ">", "0"}], ",", 
        RowBox[{"r", ">", "0"}]}], "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Calculate", " ", "intensities", " ", "for", " ", "the", " ", "platelets", 
    " ", "based", " ", "on", " ", "the", " ", "probability", " ", 
    "distributions", " ", "obtained", " ", "with", " ", "the", " ", "form", 
    " ", "factor", " ", 
    RowBox[{"fit", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"note", ";", " ", 
    RowBox[{
     RowBox[{
     "this", " ", "intensity", " ", "is", " ", "now", " ", "corrected", " ", 
      "for", " ", "the", " ", 
      RowBox[{"volume", "^", "2"}]}], "-", 
     RowBox[{
     "dependence", " ", "of", " ", "scattering", " ", "intensity"}]}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"calculateIntensitiesLR", "[", 
     RowBox[{
      RowBox[{"\[Mu]l_", "?", "NumberQ"}], ",", 
      RowBox[{"\[Sigma]l_", "?", "NumberQ"}], ",", 
      RowBox[{"\[Mu]r_", "?", "NumberQ"}], ",", 
      RowBox[{"\[Sigma]r_", "?", "NumberQ"}]}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Block", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"probabilities", ",", "data"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"probabilities", "=", "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"r", "^", "2"}], " ", "l"}], " ", ")"}], "^", "2"}], 
           RowBox[{"probfunc", "[", 
            RowBox[{
            "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r", ",", 
             "l", ",", "r"}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"r", ",", "radii"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"l", ",", "lengths"}], "}"}]}], "]"}]}], ";", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{
         "volume", " ", "weighing", " ", "for", " ", "a", " ", "cylinder", 
          " ", "of", " ", 
          RowBox[{"diameter", "^", "2"}], " ", "*", " ", 
          RowBox[{"thickness", ".", " ", "We"}], " ", "square", " ", "this"}],
          ",", " ", 
         RowBox[{"because", " ", "intensity", " ", "scales", " ", "with", " ", 
          RowBox[{"V", "^", "2"}]}]}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"probfunc", "[", 
            RowBox[{
            "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r", ",", 
             "l", ",", "r"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"r", ",", "radii"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"l", ",", "lengths"}], "}"}]}], "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"probabilities", "=", 
        RowBox[{"probabilities", "/", 
         RowBox[{"Total", "[", 
          RowBox[{"Flatten", "[", "probabilities", "]"}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"data", "=", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"qlist", ",", 
           RowBox[{"Total", "[", "\[IndentingNewLine]", 
            RowBox[{"Table", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{"probabilities", "[", 
                RowBox[{"[", "i", "]"}], "]"}], ".", 
               RowBox[{"dataAllLengths", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
              
              RowBox[{"{", 
               RowBox[{"i", ",", 
                RowBox[{"Length", "[", "probabilities", "]"}]}], "}"}]}], 
             "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}]}], 
          "}"}], "\[Transpose]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "data", "]"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",\

 CellChangeTimes->{
  3.853833992055169*^9, {3.853838966450965*^9, 3.853838966553301*^9}, {
   3.8544234235752993`*^9, 3.854423436127577*^9}, {3.854430087163003*^9, 
   3.854430130510928*^9}, {3.854430203830633*^9, 3.854430219131062*^9}, {
   3.8601385420212803`*^9, 3.860138638056221*^9}, {3.8601386828025064`*^9, 
   3.860138692836401*^9}, {3.8619498070714016`*^9, 3.861949810669832*^9}, {
   3.864111368481957*^9, 3.864111381547614*^9}, {3.8641119129600077`*^9, 
   3.864111933466826*^9}, {3.86411198099782*^9, 3.8641120377855062`*^9}, {
   3.864112243724079*^9, 3.8641122604900866`*^9}, {3.864112766219705*^9, 
   3.86411278769474*^9}, {3.8641135528767495`*^9, 3.8641135674698086`*^9}, {
   3.8641136364748583`*^9, 3.8641136872689133`*^9}, {3.864115609508887*^9, 
   3.864115696314577*^9}, {3.864115732636894*^9, 3.864115830964185*^9}, {
   3.8641158807267537`*^9, 3.8641158812495947`*^9}, {3.8641159142672977`*^9, 
   3.864115966691824*^9}, {3.8641160299919057`*^9, 3.8641160563528504`*^9}, {
   3.8641161004319696`*^9, 3.8641161468625154`*^9}, {3.8641161798404274`*^9, 
   3.8641161881638513`*^9}, {3.864116300781921*^9, 3.864116303316224*^9}, {
   3.864117598850899*^9, 3.864117610456077*^9}, {3.864117641542405*^9, 
   3.8641176697889366`*^9}, {3.864180413527955*^9, 3.864180439734521*^9}, {
   3.8641804809675617`*^9, 3.8641805484890027`*^9}, {3.864439294957782*^9, 
   3.8644393039048176`*^9}, {3.8644393915786576`*^9, 3.864439422827739*^9}, {
   3.864439453939878*^9, 3.864439469354518*^9}, {3.864439507094865*^9, 
   3.864439508154552*^9}, 3.8644397191828737`*^9, {3.8644398454503803`*^9, 
   3.8644398477143235`*^9}, {3.8644399339387035`*^9, 3.86443994606491*^9}, {
   3.886064903615081*^9, 3.8860649365245705`*^9}, {3.8860649824235754`*^9, 
   3.886065042163972*^9}, {3.8860654296691275`*^9, 3.8860654298245497`*^9}, {
   3.8860658521704564`*^9, 3.886065874983266*^9}, {3.886066040165041*^9, 
   3.886066041373247*^9}, {3.8860666771353765`*^9, 3.8860666867852397`*^9}, {
   3.887182510322879*^9, 3.887182533881962*^9}, 3.887182594924156*^9, {
   3.888309810352276*^9, 3.8883099090736856`*^9}, 3.888309979546259*^9, {
   3.889001517107656*^9, 3.889001521496806*^9}, 3.8890015518214397`*^9, {
   3.8890016534686737`*^9, 3.8890016557649727`*^9}, {3.8890018189941072`*^9, 
   3.8890019390049477`*^9}, {3.889001975497669*^9, 3.88900205859529*^9}, {
   3.8890029285899467`*^9, 3.889002953302465*^9}, {3.889061053677486*^9, 
   3.889061062588866*^9}, {3.889077630726709*^9, 3.889077637427123*^9}, {
   3.8890777314446993`*^9, 3.889077747654249*^9}, {3.88907998107436*^9, 
   3.889079982089085*^9}, {3.889080034422716*^9, 3.8890801182358418`*^9}, {
   3.889080169489069*^9, 3.889080169576085*^9}, {3.88949949386611*^9, 
   3.889499567193898*^9}, {3.8894998864287863`*^9, 3.8894998890429115`*^9}, {
   3.889500147504761*^9, 3.8895001771365824`*^9}, {3.8895002362490377`*^9, 
   3.8895002555469923`*^9}, 3.8896807810308504`*^9, {3.8896808952666397`*^9, 
   3.889680897469507*^9}, 3.8896809885482616`*^9, {3.889681435463972*^9, 
   3.889681467825818*^9}, {3.889683285411501*^9, 3.8896833249263334`*^9}, {
   3.8896836624629545`*^9, 3.889683726861018*^9}, {3.889683767007558*^9, 
   3.8896837811495934`*^9}, {3.8909840270444803`*^9, 3.890984036295034*^9}, 
   3.890984239308541*^9, {3.892626838974331*^9, 3.892626898907713*^9}, {
   3.8926270171836615`*^9, 3.8926270218689365`*^9}, {3.8926277730407066`*^9, 
   3.892627776564975*^9}, {3.8926333318437233`*^9, 3.8926333994129653`*^9}, {
   3.9020332262608376`*^9, 3.9020332963358493`*^9}, {3.9020336624352193`*^9, 
   3.9020336629539337`*^9}, {3.9020353079182467`*^9, 
   3.9020353486147013`*^9}, {3.9020363693828735`*^9, 
   3.9020363924630795`*^9}, {3.9034255328232384`*^9, 
   3.9034255543925576`*^9}, {3.903426126619336*^9, 3.903426129784585*^9}, 
   3.9046328541982255`*^9, {3.904633917772386*^9, 3.9046339197876396`*^9}, {
   3.905228211494954*^9, 3.9052282241923895`*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"904598d3-3be1-4b29-9812-e84f814faf5c"],

Cell[BoxData["30351"], "Output",
 CellChangeTimes->{3.9058513205308475`*^9, 3.906016935157094*^9, 
  3.907145142887905*^9, 3.9079088535669875`*^9},
 CellLabel->"Out[35]=",ExpressionUUID->"d4c398c7-5245-4f78-ae4f-304cd82141ee"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Mu]l", "-", 
         RowBox[{"Log", "[", "l", "]"}]}], ")"}], "2"], 
      RowBox[{"2", " ", 
       SuperscriptBox["\[Sigma]l", "2"]}]]}], "-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[Mu]r", "-", 
        RowBox[{"Log", "[", "r", "]"}]}], ")"}], "2"], 
     RowBox[{"2", " ", 
      SuperscriptBox["\[Sigma]r", "2"]}]]}]], 
  RowBox[{"2", " ", "l", " ", "\[Pi]", " ", "r", " ", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["\[Sigma]l", "2"], " ", 
     SuperscriptBox["\[Sigma]r", "2"]}]]}]]], "Output",
 CellChangeTimes->{3.9058513205308475`*^9, 3.906016935157094*^9, 
  3.907145142887905*^9, 3.9079088626541395`*^9},
 CellLabel->"Out[40]=",ExpressionUUID->"9c04c7c6-c928-477e-b0f8-21ec5538de37"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Note", ":", " ", 
     RowBox[{
     "the", " ", "initial", " ", "values", " ", "are", " ", "optional"}]}], 
    ";", " ", 
    RowBox[{
    "if", " ", "you", " ", "omit", " ", "them", " ", "the", " ", "value", " ",
      "after", " ", 
     RowBox[{"the", " ", ":", " ", 
      RowBox[{"will", " ", "be", " ", 
       RowBox[{"assumed", ".", " ", "Fit"}], " ", "slopes", " ", "with", " ", 
       "this", " ", "discrete", " ", "full", " ", "form", " ", "factor", " ", 
       "\"\<function\>\""}]}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"fitSlopeLR", "[", 
     RowBox[{"data_", ",", 
      RowBox[{"\[Mu]linitial_", ":", 
       RowBox[{"Log", "[", "30.", "]"}]}], ",", 
      RowBox[{"\[Sigma]linitial_", ":", "0.5"}], ",", 
      RowBox[{"\[Mu]rinitial_", ":", 
       RowBox[{"Log", "[", "250.", "]"}]}], ",", 
      RowBox[{"\[Sigma]rinitial_", ":", "0.5"}], ",", " ", 
      RowBox[{"binfactor_", ":", "0.15"}]}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Block", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"dataSlope", "=", 
         RowBox[{"slope", "[", 
          RowBox[{"data", ",", "binfactor"}], "]"}]}], ",", 
        "\[IndentingNewLine]", "qListDataSlope"}], "\[IndentingNewLine]", 
       "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"qListDataSlope", "=", 
        RowBox[{"dataSlope", "[", 
         RowBox[{"[", 
          RowBox[{";;", ",", "1"}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"minfuncslopeLR", "[", 
         RowBox[{
          RowBox[{"\[Mu]l_", "?", "NumberQ"}], ",", 
          RowBox[{"\[Sigma]l_", "?", "NumberQ"}], ",", 
          RowBox[{"\[Mu]r_", "?", "NumberQ"}], ",", 
          RowBox[{"\[Sigma]r_", "?", "NumberQ"}]}], "]"}], ":=", 
        RowBox[{
         RowBox[{"Norm", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"slope", "[", 
             RowBox[{"calculateIntensitiesLR", "[", 
              RowBox[{
              "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
              "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"Flatten", "[", 
               RowBox[{"Nearest", "[", 
                RowBox[{
                 RowBox[{"qlistslope", "\[Rule]", "\"\<Index\>\""}], ",", 
                 "qListDataSlope"}], "]"}], "]"}], ",", "2"}], "]"}], "]"}], 
           "-", "\[IndentingNewLine]", 
           RowBox[{"dataSlope", "[", 
            RowBox[{"[", 
             RowBox[{";;", ",", "2"}], "]"}], "]"}]}], "]"}], "[", 
         "\"\<Value\>\"", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"fmfSLR", "=", 
        RowBox[{"FindMinimum", "[", "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"minfuncslopeLR", "[", 
             RowBox[{
             "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
             "]"}], " ", ",", " ", 
            RowBox[{"\[Mu]l", " ", ">", " ", "0"}], ",", " ", 
            RowBox[{"\[Sigma]l", " ", ">", " ", "0"}], ",", " ", 
            RowBox[{"\[Mu]r", " ", ">", " ", "0"}], ",", " ", 
            RowBox[{"\[Sigma]r", ">", "0"}]}], " ", "}"}], "*)"}], " ", 
         RowBox[{"(*", " ", 
          RowBox[{"constraint", ":", " ", 
           RowBox[{"sigma", " ", ">", " ", "0"}]}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{"minfuncslopeLR", "[", 
           RowBox[{
           "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
           "]"}], "*)"}], "  ", 
         RowBox[{"(*", " ", "default", " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"minfuncslopeLR", "[", 
           RowBox[{
            RowBox[{"Abs", "[", "\[Mu]l", "]"}], ",", 
            RowBox[{"Abs", "[", "\[Sigma]l", "]"}], ",", 
            RowBox[{"Abs", "[", "\[Mu]r", "]"}], ",", 
            RowBox[{"Abs", "[", "\[Sigma]r", "]"}]}], " ", 
           RowBox[{"(*", " ", 
            RowBox[{
            "take", " ", "absolute", " ", "values", " ", "to", " ", "prevent",
              " ", "negative", " ", "fit", " ", "results"}], " ", "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{"AccuracyGoal", " ", "->", " ", "5"}], ",", " ", 
             RowBox[{"PrecisionGoal", " ", "->", " ", "5"}]}], "*)"}], "]"}], 
          "  ", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Try", " ", "to", " ", "reduce", " ", "computation", " ", "time", 
            " ", "by", " ", "asking", " ", "for", " ", "lower", " ", 
            "accuracy", " ", "and", " ", 
            RowBox[{"precision", "."}]}], "*)"}], "\[IndentingNewLine]", ",", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\[Mu]l", ",", "\[Mu]linitial"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\[Sigma]l", ",", "\[Sigma]linitial"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\[Mu]r", ",", "\[Mu]rinitial"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\[Sigma]r", ",", "\[Sigma]rinitial"}], "}"}]}], "}"}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{"StepMonitor", "\[RuleDelayed]", 
           RowBox[{"Print", "[", 
            RowBox[{
            "\"\<\[Mu]l = \>\"", ",", "\[Mu]l", ",", "\"\< \[Sigma]l = \>\"", 
             ",", "\[Sigma]l", ",", "\"\< \[Mu]r = \>\"", ",", 
             RowBox[{"\[Mu]r", "\"\< \[Sigma]r = \>\""}], ",", "\[Sigma]r"}], 
            "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"Method", "->", "\"\<QuasiNewton\>\""}]}], 
         "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "->", 
             RowBox[{"Abs", "[", 
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "&"}], "/@", 
           RowBox[{"fmfSLR", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "~", "Join", "~", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Mu]lx", "->", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"\[Mu]l", "+", 
                FractionBox[
                 SuperscriptBox["\[Sigma]l", "2"], "2"]}]]}], ",", 
             RowBox[{"\[Sigma]lx", "->", 
              RowBox[{
               SuperscriptBox["\[ExponentialE]", "\[Mu]l"], " ", 
               RowBox[{"\[Sqrt]", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["\[ExponentialE]", 
                   SuperscriptBox["\[Sigma]l", "2"]], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    SuperscriptBox["\[Sigma]l", "2"]], "-", "1"}], ")"}]}], 
                 ")"}]}]}]}], ",", 
             RowBox[{"\[Mu]rx", "->", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"\[Mu]r", "+", 
                FractionBox[
                 SuperscriptBox["\[Sigma]r", "2"], "2"]}]]}], ",", 
             RowBox[{"\[Sigma]rx", "->", 
              RowBox[{
               SuperscriptBox["\[ExponentialE]", "\[Mu]r"], " ", 
               RowBox[{"\[Sqrt]", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["\[ExponentialE]", 
                   SuperscriptBox["\[Sigma]r", "2"]], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    SuperscriptBox["\[Sigma]r", "2"]], "-", "1"}], ")"}]}], 
                 ")"}]}]}]}]}], "}"}], "/.", 
           RowBox[{"fmfSLR", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], 
        RowBox[{"(*", " ", 
         RowBox[{
         "take", " ", "absolute", " ", "values", " ", "to", " ", "prevent", 
          " ", "negative", " ", "fit", " ", "results"}], " ", "*)"}], 
        "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Fit", " ", "the", " ", "entire", " ", "SAXS", " ", "pattern", " ", 
      "with", " ", "the", " ", "platelets", " ", "form", " ", "factor"}], " ",
      "-", " ", 
     RowBox[{"volume", " ", "weighted"}], " ", "-", " ", 
     RowBox[{
     "this", " ", "intensity", " ", "fit", " ", "is", " ", "much", " ", 
      "slower", " ", "than", " ", "the", " ", "slope", " ", "fit", " ", "and",
       " ", "gives", " ", "similar", " ", "results", " ", "for", " ", "the", 
      " ", "lamellae", " ", "form", " ", "factor"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fitIntensityLR", "[", 
     RowBox[{"data_", ",", 
      RowBox[{"\[Mu]linitial_", ":", 
       RowBox[{"Log", "[", "30.", "]"}]}], ",", 
      RowBox[{"\[Sigma]linitial_", ":", "0.5"}], ",", 
      RowBox[{"\[Mu]rinitial_", ":", 
       RowBox[{"Log", "[", "250.", "]"}]}], ",", 
      RowBox[{"\[Sigma]rinitial_", ":", "0.5"}]}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Block", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"qListIntensity", "=", 
         RowBox[{"data", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "2"}], "]"}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"qListDataIntensity", " ", "=", " ", 
         RowBox[{"data", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "1"}], "]"}], "]"}]}]}], "\[IndentingNewLine]", 
       "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"qListIntensity", " ", "=", " ", 
         RowBox[{"qListIntensity", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "1"}], "]"}], "]"}]}], ";"}], "*)"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"minfuncfullfit", "[", 
         RowBox[{
          RowBox[{"\[Mu]l_", "?", "NumberQ"}], ",", 
          RowBox[{"\[Sigma]l_", "?", "NumberQ"}], ",", 
          RowBox[{"\[Mu]r_", "?", "NumberQ"}], ",", 
          RowBox[{"\[Sigma]r_", "?", "NumberQ"}]}], "]"}], ":=", 
        RowBox[{"Norm", "[", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"data", "[", 
            RowBox[{"[", 
             RowBox[{";;", ",", "2"}], "]"}], "]"}], "]"}], "-", 
          RowBox[{"Log", "[", 
           RowBox[{
            RowBox[{"calculateIntensitiesLRqlist", "[", 
             RowBox[{
             "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r", " ",
               ",", " ", "qListIntensity"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{";;", ",", "2"}], "]"}], "]"}], "]"}]}], "]"}]}], ";", 
       " ", 
       RowBox[{"(*", " ", 
        RowBox[{
        "two", " ", "terms", " ", "not", " ", "of", " ", "equal", " ", 
         "length"}], "*)"}], " ", 
       RowBox[{"(*", " ", 
        RowBox[{
        "should", " ", "we", " ", "ask", " ", "a", " ", "scale", " ", 
         RowBox[{"parameter", "?", " ", "scale_", "?", "NumberQ"}], " ", "to",
          " ", "the", " ", "calculateintensity", " ", 
         RowBox[{"function", "?"}]}], "*)"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"solint", "=", 
        RowBox[{"FindMinimum", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{"minfuncfullfit", "[", 
            RowBox[{
             RowBox[{"Abs", "[", "\[Mu]l", "]"}], ",", 
             RowBox[{"Abs", "[", "\[Sigma]l", "]"}], ",", 
             RowBox[{"Abs", "[", "\[Mu]r", "]"}], ",", 
             RowBox[{"Abs", "[", "\[Sigma]r", "]"}]}], "]"}], "  ", 
           RowBox[{"(*", " ", 
            RowBox[{
            "take", " ", "absolute", " ", "values", " ", "to", " ", "prevent",
              " ", "negative", " ", "fit", " ", "results"}], " ", "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{"minfuncfullfit", "[", 
             RowBox[{
             "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
             "]"}], "  ", 
            RowBox[{"(*", " ", 
             RowBox[{
             "take", " ", "absolute", " ", "values", " ", "to", " ", 
              "prevent", " ", "negative", " ", "fit", " ", "results"}], " ", 
             "*)"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"scale", ",", "1"}], "}"}], ","}], "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\[Mu]l", ",", "\[Mu]linitial"}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"\[Sigma]l", ",", "\[Sigma]linitial"}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"\[Mu]r", ",", "\[Mu]linitial"}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"\[Sigma]r", ",", "\[Sigma]linitial"}], "}"}]}], 
           "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"StepMonitor", "\[RuleDelayed]", 
           RowBox[{"Print", "[", 
            RowBox[{
            "\"\<\[Mu]l = \>\"", ",", "\[Mu]l", ",", "\"\< \[Sigma]l = \>\"", 
             ",", "\[Sigma]l", ",", "\"\<\[Mu]r = \>\"", ",", "\[Mu]r", ",", 
             "\"\< \[Sigma]r = \>\"", ",", "\[Sigma]r"}], "]"}]}], " ", 
          RowBox[{"(*", 
           RowBox[{
           ",", "\"\< scale = \>\"", ",", "scale", " ", ",", " ", 
            "\"\<, func = \>\"", ",", 
            RowBox[{"minfuncfullfit", "[", 
             RowBox[{"\[Mu]", ",", "\[Sigma]", ",", "scale"}], "]"}]}], 
           "*)"}], ","}], "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{"Method", "->", "\"\<QuasiNewton\>\""}], " ", "*)"}], 
         RowBox[{"(*", " ", 
          RowBox[{
          "we", " ", "did", " ", "not", " ", "specify", " ", "the", " ", 
           "method", " ", "previously"}], "*)"}], "\[IndentingNewLine]", 
         "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"solint", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "~", "Join", "~", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"\[Mu]x", "->", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"\[Mu]", "+", 
                 FractionBox[
                  SuperscriptBox["\[Sigma]", "2"], "2"]}]]}], ",", 
              RowBox[{"\[Sigma]x", "->", 
               RowBox[{
                SuperscriptBox["\[ExponentialE]", "\[Mu]"], " ", 
                RowBox[{"\[Sqrt]", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["\[ExponentialE]", 
                    SuperscriptBox["\[Sigma]", "2"]], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    SuperscriptBox["\[Sigma]", "2"]], "-", "1"}], ")"}]}], 
                  ")"}]}]}]}]}], "}"}], "/.", 
            RowBox[{"solint", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "->", 
             RowBox[{"Abs", "[", 
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "&"}], "/@", 
           RowBox[{"solint", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "~", "Join", "~", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Mu]lx", "->", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"\[Mu]l", "+", 
                FractionBox[
                 SuperscriptBox["\[Sigma]l", "2"], "2"]}]]}], ",", 
             RowBox[{"\[Sigma]lx", "->", 
              RowBox[{
               SuperscriptBox["\[ExponentialE]", "\[Mu]l"], " ", 
               RowBox[{"\[Sqrt]", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["\[ExponentialE]", 
                   SuperscriptBox["\[Sigma]l", "2"]], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    SuperscriptBox["\[Sigma]l", "2"]], "-", "1"}], ")"}]}], 
                 ")"}]}]}]}], ",", 
             RowBox[{"\[Mu]rx", "->", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"\[Mu]r", "+", 
                FractionBox[
                 SuperscriptBox["\[Sigma]r", "2"], "2"]}]]}], ",", 
             RowBox[{"\[Sigma]rx", "->", 
              RowBox[{
               SuperscriptBox["\[ExponentialE]", "\[Mu]r"], " ", 
               RowBox[{"\[Sqrt]", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["\[ExponentialE]", 
                   SuperscriptBox["\[Sigma]r", "2"]], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    SuperscriptBox["\[Sigma]r", "2"]], "-", "1"}], ")"}]}], 
                 ")"}]}]}]}]}], "}"}], "/.", 
           RowBox[{"solint", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "\[IndentingNewLine]", 
        
        RowBox[{"(*", " ", 
         RowBox[{
         "take", " ", "absolute", " ", "values", " ", "to", " ", "prevent", 
          " ", "negative", " ", "fit", " ", "results"}], " ", "*)"}], 
        "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
     "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.853833992055169*^9, {3.853838966450965*^9, 3.853838966553301*^9}, {
   3.8544234235752993`*^9, 3.854423436127577*^9}, {3.854430087163003*^9, 
   3.854430130510928*^9}, {3.854430203830633*^9, 3.854430219131062*^9}, {
   3.8601385420212803`*^9, 3.860138638056221*^9}, {3.8601386828025064`*^9, 
   3.860138692836401*^9}, {3.8619498070714016`*^9, 3.861949810669832*^9}, {
   3.864111368481957*^9, 3.864111381547614*^9}, {3.8641119129600077`*^9, 
   3.864111933466826*^9}, {3.86411198099782*^9, 3.8641120377855062`*^9}, {
   3.864112243724079*^9, 3.8641122604900866`*^9}, {3.864112766219705*^9, 
   3.86411278769474*^9}, {3.8641135528767495`*^9, 3.8641135674698086`*^9}, {
   3.8641136364748583`*^9, 3.8641136872689133`*^9}, {3.864115609508887*^9, 
   3.864115696314577*^9}, {3.864115732636894*^9, 3.864115830964185*^9}, {
   3.8641158807267537`*^9, 3.8641158812495947`*^9}, {3.8641159142672977`*^9, 
   3.864115966691824*^9}, {3.8641160299919057`*^9, 3.8641160563528504`*^9}, {
   3.8641161004319696`*^9, 3.8641161468625154`*^9}, {3.8641161798404274`*^9, 
   3.8641161881638513`*^9}, {3.864116300781921*^9, 3.864116303316224*^9}, {
   3.864117598850899*^9, 3.864117610456077*^9}, {3.864117641542405*^9, 
   3.8641176697889366`*^9}, {3.864180413527955*^9, 3.864180439734521*^9}, {
   3.8641804809675617`*^9, 3.8641805484890027`*^9}, {3.864439294957782*^9, 
   3.8644393039048176`*^9}, {3.8644393915786576`*^9, 3.864439422827739*^9}, {
   3.864439453939878*^9, 3.864439469354518*^9}, {3.864439507094865*^9, 
   3.864439508154552*^9}, 3.8644397191828737`*^9, {3.8644398454503803`*^9, 
   3.8644398477143235`*^9}, {3.8644399339387035`*^9, 3.86443994606491*^9}, {
   3.886064903615081*^9, 3.8860649365245705`*^9}, {3.8860649824235754`*^9, 
   3.886065042163972*^9}, {3.8860654296691275`*^9, 3.8860654298245497`*^9}, {
   3.8860658521704564`*^9, 3.886065874983266*^9}, {3.886066040165041*^9, 
   3.886066041373247*^9}, {3.8860666771353765`*^9, 3.8860666867852397`*^9}, {
   3.887182510322879*^9, 3.887182533881962*^9}, 3.887182594924156*^9, {
   3.888309810352276*^9, 3.8883099090736856`*^9}, 3.888309979546259*^9, {
   3.889001517107656*^9, 3.889001521496806*^9}, 3.8890015518214397`*^9, {
   3.8890016534686737`*^9, 3.8890016557649727`*^9}, {3.8890018189941072`*^9, 
   3.8890019390049477`*^9}, {3.889001975497669*^9, 3.8890020072173767`*^9}, {
   3.889002614228364*^9, 3.8890026313484697`*^9}, {3.889077832884159*^9, 
   3.889077894603732*^9}, {3.889080182454623*^9, 3.889080182537393*^9}, {
   3.8890822541823463`*^9, 3.8890822952851562`*^9}, {3.889082341655233*^9, 
   3.889082344557757*^9}, {3.889082656479224*^9, 3.8890826670260477`*^9}, {
   3.8890828570654707`*^9, 3.889082869681726*^9}, {3.889082911422908*^9, 
   3.889082918957836*^9}, {3.8895003750115547`*^9, 3.8895003897150297`*^9}, {
   3.8895018994156485`*^9, 3.8895019010220375`*^9}, {3.889503150539938*^9, 
   3.8895031777290506`*^9}, {3.8896809063671813`*^9, 
   3.8896810153449264`*^9}, {3.8896810571842823`*^9, 
   3.8896811412259593`*^9}, {3.889681489021313*^9, 3.8896815167211204`*^9}, {
   3.8896816106523666`*^9, 3.8896817796390357`*^9}, {3.8896820398977776`*^9, 
   3.889682095914321*^9}, 3.8896821349393435`*^9, {3.889682203278436*^9, 
   3.8896822073970346`*^9}, 3.889682405803105*^9, {3.889683225636203*^9, 
   3.8896832268268085`*^9}, {3.889683264087661*^9, 3.8896832726744494`*^9}, {
   3.8902008849918118`*^9, 3.890200911254434*^9}, {3.891414478168077*^9, 
   3.89141454535581*^9}, {3.8914145789251857`*^9, 3.891414624133849*^9}, {
   3.8914150625685744`*^9, 3.8914152262658043`*^9}, {3.8914159481837835`*^9, 
   3.8914159627995386`*^9}, {3.891417522295415*^9, 3.8914175385413494`*^9}, 
   3.891427879634804*^9, {3.891427987429741*^9, 3.8914280388778486`*^9}, {
   3.8914908223125954`*^9, 3.8914908272757816`*^9}, {3.9034214157801332`*^9, 
   3.9034214559628935`*^9}, 3.9034215153083286`*^9, {3.903421635003624*^9, 
   3.9034216676164503`*^9}, {3.9034217652411594`*^9, 
   3.9034217655448523`*^9}, {3.903421878350258*^9, 3.903421922978465*^9}, {
   3.9034219682375975`*^9, 3.9034221273813486`*^9}, {3.903422167139739*^9, 
   3.9034222293512406`*^9}, 3.903422326229187*^9, 3.903423188186224*^9, {
   3.903423322373499*^9, 3.9034233342236347`*^9}, {3.9034233909444113`*^9, 
   3.9034234363318615`*^9}, {3.9034235328876123`*^9, 3.903423533172177*^9}, 
   3.903423571559184*^9, {3.903423613971017*^9, 3.903423628462083*^9}, 
   3.9034237309258165`*^9, 3.903423784832442*^9, {3.903423869041752*^9, 
   3.903423879202055*^9}, {3.903423920430318*^9, 3.9034239630320497`*^9}, 
   3.903424130613789*^9, {3.903424939479628*^9, 3.9034249554049816`*^9}, {
   3.9034252419827557`*^9, 3.903425251266121*^9}, {3.9034256201581697`*^9, 
   3.9034256635257635`*^9}, {3.9052282458576093`*^9, 3.905228255448001*^9}, {
   3.907839824541335*^9, 3.907839836448653*^9}, {3.907839926226036*^9, 
   3.907839928291877*^9}, {3.907840034205261*^9, 3.9078400370754724`*^9}, {
   3.9078402899263597`*^9, 3.9078403414919567`*^9}, {3.9078406086387076`*^9, 
   3.9078406120886383`*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"4d2ca9cf-a791-490d-b630-3cfaa5886fc0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plot settings", "Section",
 CellChangeTimes->{{3.9042072693332744`*^9, 
  3.904207274139716*^9}},ExpressionUUID->"105337f8-9f71-463c-ba4f-\
5445b245946c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"inch", " ", "=", " ", "84"}], " ", ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Should", " ", "be", " ", "72", " ", "for", " ", "Mac", " ", "or", " ", 
     "96", " ", "for", " ", "windows"}], ",", " ", 
    RowBox[{
    "but", " ", "somehow", " ", "I", " ", "dont", " ", "obtain", " ", "the", 
     " ", "specified", " ", "image", " ", "sizes", " ", "that", " ", 
     RowBox[{"way", "."}]}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cm", " ", "=", " ", 
   RowBox[{"inch", "/", "2.54"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904207973596441*^9, 3.904207974366299*^9}, {
  3.904208548778447*^9, 3.904208549320463*^9}, {3.9042087180049963`*^9, 
  3.904208749302359*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"e93dc968-6479-4f4d-8783-58aeb15a1214"],

Cell[CellGroupData[{

Cell["\<\
Function to get logarithmic tick marks in scientific notation\
\>", "Subsection",
 CellChangeTimes->{{3.889675803215909*^9, 
  3.889675825628518*^9}},ExpressionUUID->"2c7e915b-284b-4a52-9077-\
42b65bc60a51"],

Cell["\<\
From https://stackoverflow.com/questions/5669073/force-scientific-notation-in-\
tick-labels-of-listloglogplot. \[LineSeparator]Was really annoyed that \
apparently it\[CloseCurlyQuote]s super hard to choose your own tick labels in \
mathematica in combination with logarithmic tick marks\
\>", "Text",
 CellChangeTimes->{{3.8896758423204074`*^9, 3.889675874699585*^9}, {
  3.8896759137086077`*^9, 
  3.8896759250674143`*^9}},ExpressionUUID->"0716ec73-f7da-4d51-adfc-\
df2d5f6b72d6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PowerTicks", "[", "label_", "]"}], "[", 
    RowBox[{"min_", ",", "max_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"min10", ",", "max10"}], "}"}], ",", 
     RowBox[{
      RowBox[{"min10", "=", 
       RowBox[{"Floor", "[", 
        RowBox[{"Log10", "[", "min", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"max10", "=", 
       RowBox[{"Ceiling", "[", 
        RowBox[{"Log10", "[", "max", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"10", "^", "i"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{"label", ",", 
              RowBox[{"Superscript", "[", 
               RowBox[{"10", ",", "i"}], "]"}], ",", 
              RowBox[{"Spacer", "[", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "]"}]}], "}"}], ",", 
          
          RowBox[{"{", 
           RowBox[{"i", ",", "min10", ",", "max10"}], "}"}]}], "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"k", " ", 
               RowBox[{"10", "^", "i"}]}], ",", 
              RowBox[{"Spacer", "[", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.005", ",", "0.`"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Thickness", "[", "0.001`", "]"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "min10", ",", "max10"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"k", ",", "9"}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
       "]"}]}]}], "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"use", " ", "example"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"ListLogLogPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Range", "[", "20", "]"}], "^", "3"}], ",", 
     RowBox[{"Frame", "->", "True"}], ",", 
     RowBox[{"FrameTicks", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
          RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
          RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}]}], 
    "]"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "skip", " ", "every", " ", "second", " ", "tick", " ", "label", " ", "for",
     " ", "readability"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PowerTicks2", "[", "label_", "]"}], "[", 
   RowBox[{"min_", ",", "max_"}], "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"min10", ",", "max10"}], "}"}], ",", 
    RowBox[{
     RowBox[{"min10", "=", 
      RowBox[{"Floor", "[", 
       RowBox[{"Log10", "[", "min", "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"max10", "=", 
      RowBox[{"Ceiling", "[", 
       RowBox[{"Log10", "[", "max", "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"10", "^", "i"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{"label", ",", 
               RowBox[{"Superscript", "[", 
                RowBox[{"10", ",", "i"}], "]"}], ",", 
               RowBox[{"Spacer", "[", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "min10", ",", "max10", ",", "2"}], "}"}]}], 
          "]"}], ",", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"k", " ", 
                RowBox[{"10", "^", "i"}]}], ",", 
               RowBox[{"Spacer", "[", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"0.005", ",", "0.`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"Thickness", "[", "0.001`", "]"}], "}"}]}], "}"}], 
             ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "min10", ",", "max10"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"k", ",", "9"}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
        "]"}], "]"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", "i"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{"label", ",", 
             RowBox[{"Superscript", "[", 
              RowBox[{"10", ",", "i"}], "]"}], ",", 
             RowBox[{"Spacer", "[", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "min10", ",", "max10", ",", "2"}], "}"}]}], "]"}],
        ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", "i"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{"label", ",", " ", 
             RowBox[{"Spacer", "[", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"10", "min10"}], ",", 
           RowBox[{"10", "max10"}], ",", "2"}], "}"}]}], "]"}], ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"k", " ", 
              RowBox[{"10", "^", "i"}]}], ",", 
             RowBox[{"Spacer", "[", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.005", ",", "0.`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Thickness", "[", "0.001`", "]"}], "}"}]}], "}"}], ",", 
           
           RowBox[{"{", 
            RowBox[{"i", ",", "min10", ",", "max10"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"k", ",", "9"}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
      "]"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{
  3.8896758773232393`*^9, {3.8896759377796016`*^9, 3.889675951308181*^9}, {
   3.904191636037596*^9, 3.904191689658992*^9}, {3.904191749911257*^9, 
   3.90419175021442*^9}, {3.9041924745204535`*^9, 3.9041925014087954`*^9}, {
   3.904192735930566*^9, 3.9041928026204376`*^9}, {3.904192834250898*^9, 
   3.904192884253207*^9}, {3.904192951520898*^9, 3.904193158931017*^9}, {
   3.9041932332658277`*^9, 3.904193246485846*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"3ff1d24a-bfe7-4aef-b22b-89321bdbef81"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Title",
 CellChangeTimes->{{3.889081816418654*^9, 
  3.8890818172763433`*^9}},ExpressionUUID->"d8104e96-bcdf-4d40-8ea7-\
520991da3e70"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "EXAMPLE", " ", "plots", " ", "of", " ", "the", " ", "monodisperse", " ", 
     "and", " ", "polydisperse", " ", "form", " ", 
     RowBox[{
     "factors", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "They"}], 
     " ", "are", " ", "very", " ", "similar"}], ",", " ", 
    RowBox[{
     RowBox[{"but", " ", "the", " ", "one", " ", 
      RowBox[{"(", "P11", ")"}], " ", "for", " ", "actual", " ", "disks", " ",
       "is", " ", 
      RowBox[{"better", ":", " ", 
       RowBox[{"the", " ", "form", " ", "factor", " ", "P", 
        RowBox[{"(", "Q", ")"}], " ", "is", " ", "always", " ", "1", " ", 
        "for", " ", "Q"}]}]}], "->", 
     RowBox[{"0.", " ", "For", " ", "the", " ", "lamellae", " ", "P", 
      RowBox[{"(", 
       RowBox[{"Q", "->", "0"}], ")"}], " ", "depends", " ", "on", " ", "the",
       " ", "thickness", " ", "L"}]}], ",", " ", 
    RowBox[{
     RowBox[{
     "which", " ", "influences", " ", "results", " ", "when", " ", "fitting", 
      " ", "polydisperse", " ", "cases"}], ";", " ", 
     RowBox[{"see", " ", "slope", " ", "plot", " ", 
      RowBox[{"below", "."}]}]}]}], "\[IndentingNewLine]", " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"qlist", ",", 
          RowBox[{"Isheets", "[", 
           RowBox[{"qlist", ",", "10"}], "]"}]}], "}"}], "\[Transpose]"}], 
       ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"qlist", ",", 
          RowBox[{"Isheets", "[", 
           RowBox[{"qlist", ",", "40"}], "]"}]}], "}"}], "\[Transpose]"}], 
       ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"qlist", ",", 
          RowBox[{"P11", "[", 
           RowBox[{"qlist", ",", "250", ",", "10"}], "]"}]}], "}"}], 
        "\[Transpose]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"qlist", ",", 
          RowBox[{"P11", "[", 
           RowBox[{"qlist", ",", "250", ",", "40"}], "]"}]}], "}"}], 
        "\[Transpose]"}]}], "\[IndentingNewLine]", "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Joined", "->", "True"}]}], "\[IndentingNewLine]", "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"one", " ", "example", " ", "form", " ", "factor"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"qlist", ",", 
           RowBox[{"Isheets", "[", 
            RowBox[{"qlist", ",", "10"}], "]"}]}], "}"}], "\[Transpose]"}], 
        ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"qlist", ",", 
           RowBox[{"Isheets", "[", 
            RowBox[{"qlist", ",", "40"}], "]"}]}], "}"}], "\[Transpose]"}], 
        ","}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"qlist", ",", 
         RowBox[{"P11", "[", 
          RowBox[{"qlist", ",", "250", ",", "10"}], "]"}]}], "}"}], 
       "\[Transpose]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"qlist", ",", 
          RowBox[{"P11", "[", 
           RowBox[{"qlist", ",", "250", ",", "40"}], "]"}]}], "}"}], 
        "\[Transpose]"}], "*)"}], "\[IndentingNewLine]", "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", " ", "->", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "\"\<P(\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\))\>\"", ",", " ",
           "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"LabelStyle", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontSize", " ", "->", " ", "18"}], ",", " ", "Black"}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
    "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "one", " ", "example", " ", "polydisperse", " ", "form", " ", "factor"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{
        RowBox[{"Log", "[", "10.", "]"}], ",", "0.8", ",", 
        RowBox[{"Log", "[", "250.", "]"}], ",", "0.5"}], "]"}], 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"intPolydisp", "[", 
        RowBox[{
         RowBox[{"Log", "[", "40.", "]"}], ",", "0.6", ",", "qlist", ",", 
         RowBox[{"10", "^", 
          RowBox[{"-", "3.3"}]}]}], "]"}], "*)"}], "\[IndentingNewLine]", 
      "}"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", " ", "->", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*StyleBox[\"P\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"(\
\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\)\!\(\*\
StyleBox[\")\",FontSlant->\"Italic\"]\)\>\"", ",", " ", "None"}], "}"}], ",", 
        
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"LabelStyle", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontSize", " ", "->", " ", "18"}], ",", " ", "Black"}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
    "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"calculateIntensitiesLR", "[", 
        RowBox[{
         RowBox[{"Log", "[", "40.", "]"}], ",", "0.8", ",", 
         RowBox[{"Log", "[", "250.", "]"}], ",", "0.5"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"intPolydisp", "[", 
        RowBox[{
         RowBox[{"Log", "[", "40.", "]"}], ",", "0.6", ",", "qlist", ",", 
         RowBox[{"10", "^", 
          RowBox[{"-", "3.3"}]}]}], "]"}]}], "\[IndentingNewLine]", "}"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", " ", "->", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*StyleBox[\"P\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"(\
\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\)\!\(\*\
StyleBox[\")\",FontSlant->\"Italic\"]\)\>\"", ",", " ", "None"}], "}"}], ",", 
        
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"LabelStyle", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontSize", " ", "->", " ", "18"}], ",", " ", "Black"}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
    "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"Log", "[", "40.", "]"}], ",", "0.6", ",", 
          RowBox[{"Log", "[", "250.", "]"}], ",", "0.2"}], "]"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"slope", "[", 
        RowBox[{"intPolydisp", "[", 
         RowBox[{
          RowBox[{"Log", "[", "40.", "]"}], ",", "0.6", ",", "qlist", ",", 
          RowBox[{"10", "^", 
           RowBox[{"-", "3.3"}]}]}], "]"}], "]"}]}], "\[IndentingNewLine]", 
      "}"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", " ", "->", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"LabelStyle", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontSize", " ", "->", " ", "18"}], ",", " ", "Black"}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
    "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "calculated", " ", "slopes", " ", "for", " ", "one", " ", "example"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"slope", "[", 
       RowBox[{"calculateIntensitiesLR", "[", 
        RowBox[{
         RowBox[{"Log", "[", "10.", "]"}], ",", "0.8", ",", 
         RowBox[{"Log", "[", "250.", "]"}], ",", "0.5"}], "]"}], "]"}], 
      "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", " ", "->", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"LabelStyle", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontSize", " ", "->", " ", "18"}], ",", " ", "Black"}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
    "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.853833992055169*^9, {3.853838966450965*^9, 3.853838966553301*^9}, {
   3.8544234235752993`*^9, 3.854423436127577*^9}, {3.854430087163003*^9, 
   3.854430130510928*^9}, {3.854430203830633*^9, 3.854430219131062*^9}, {
   3.8601385420212803`*^9, 3.860138638056221*^9}, {3.8601386828025064`*^9, 
   3.860138692836401*^9}, {3.8619498070714016`*^9, 3.861949810669832*^9}, {
   3.864111368481957*^9, 3.864111381547614*^9}, {3.8641119129600077`*^9, 
   3.864111933466826*^9}, {3.86411198099782*^9, 3.8641120377855062`*^9}, {
   3.864112243724079*^9, 3.8641122604900866`*^9}, {3.864112766219705*^9, 
   3.86411278769474*^9}, {3.8641135528767495`*^9, 3.8641135674698086`*^9}, {
   3.8641136364748583`*^9, 3.8641136872689133`*^9}, {3.864115609508887*^9, 
   3.864115696314577*^9}, {3.864115732636894*^9, 3.864115830964185*^9}, {
   3.8641158807267537`*^9, 3.8641158812495947`*^9}, {3.8641159142672977`*^9, 
   3.864115966691824*^9}, {3.8641160299919057`*^9, 3.8641160563528504`*^9}, {
   3.8641161004319696`*^9, 3.8641161468625154`*^9}, {3.8641161798404274`*^9, 
   3.8641161881638513`*^9}, {3.864116300781921*^9, 3.864116303316224*^9}, {
   3.864117598850899*^9, 3.864117610456077*^9}, {3.864117641542405*^9, 
   3.8641176697889366`*^9}, {3.864180413527955*^9, 3.864180439734521*^9}, {
   3.8641804809675617`*^9, 3.8641805484890027`*^9}, {3.864439294957782*^9, 
   3.8644393039048176`*^9}, {3.8644393915786576`*^9, 3.864439422827739*^9}, {
   3.864439453939878*^9, 3.864439469354518*^9}, {3.864439507094865*^9, 
   3.864439508154552*^9}, 3.8644397191828737`*^9, {3.8644398454503803`*^9, 
   3.8644398477143235`*^9}, {3.8644399339387035`*^9, 3.86443994606491*^9}, {
   3.886064903615081*^9, 3.8860649365245705`*^9}, {3.8860649824235754`*^9, 
   3.886065042163972*^9}, {3.8860654296691275`*^9, 3.8860654298245497`*^9}, {
   3.8860658521704564`*^9, 3.886065874983266*^9}, {3.886066040165041*^9, 
   3.886066041373247*^9}, {3.8860666771353765`*^9, 3.8860666867852397`*^9}, {
   3.887182510322879*^9, 3.887182533881962*^9}, 3.887182594924156*^9, {
   3.888309810352276*^9, 3.8883099090736856`*^9}, 3.888309979546259*^9, {
   3.889001517107656*^9, 3.889001521496806*^9}, 3.8890015518214397`*^9, {
   3.8890016534686737`*^9, 3.8890016557649727`*^9}, {3.8890018189941072`*^9, 
   3.8890019390049477`*^9}, {3.889001975497669*^9, 3.889002071551203*^9}, {
   3.88908017920782*^9, 3.8890801792936077`*^9}, {3.8890803042138767`*^9, 
   3.8890803393388777`*^9}, {3.889080399346223*^9, 3.88908039943169*^9}, {
   3.889080432285198*^9, 3.88908043295632*^9}, {3.8890805058626204`*^9, 
   3.889080523792141*^9}, {3.8890805689399967`*^9, 3.88908063626715*^9}, {
   3.889080678277158*^9, 3.889080691158598*^9}, {3.889080803941393*^9, 
   3.889080811995376*^9}, {3.8890808810469437`*^9, 3.889080901180773*^9}, {
   3.889080979216024*^9, 3.889080999782426*^9}, {3.8890813330369587`*^9, 
   3.889081473443778*^9}, {3.889081541759335*^9, 3.8890816493962383`*^9}, {
   3.8890817114954777`*^9, 3.88908172105647*^9}, {3.8890843321238613`*^9, 
   3.889084359480877*^9}, {3.902035503269289*^9, 3.9020355944478807`*^9}, {
   3.902035837321357*^9, 3.90203588455401*^9}, {3.9020364783077593`*^9, 
   3.90203649464856*^9}, {3.902036696218521*^9, 3.9020366965866585`*^9}, {
   3.902043225131276*^9, 3.9020432417891912`*^9}, {3.9041259208181815`*^9, 
   3.9041259361936593`*^9}},
 CellLabel->
  "In[678]:=",ExpressionUUID->"ccb04c64-cfac-4dcb-b945-caef09e3f7b0"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.007333333333333334], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw9lglYTekfx2+3fbm6+73de7tLu/ZSmpD3HdllRCTTppB9ShhLhP9kyxhb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      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], PointSize[0.007333333333333334], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw1lgs4VOkfx8e45drMmDEXxpgZI7lksNUS3tfK6k5FtISke1tJF1aSJVtr
5V8ohEq6p7ai2sL5kRQRbQoJJUuhFiWXou1/zsw8zzzznOfM+57f+718ZsSh
W5asptNotKpv7/9/nviakvn7SSNIMTwfnvBIikP8LTeFbjMC4z05aT8dl2LT
qxWuTu5GYJ3UlyzfKsXtWsFMFtsIjqUfWq7hJsXHQ0dfv+0UQFmh2YcWphQH
30m9UVYkgNKpj32vdkiwiD3tQGaiAHTa5+1OvC7BbZseBIT7CWBOZ3lIQIIE
594LnTbXQgBQ8/yLra8EB5mM08SjfAh5dmSumrkEm+w6+mSkig83/lqEmj6J
cWud3Zn6LD64qeY8vXhfjHMsaiLPbeTDnvoFqrEZYhwUt2b+Xmc+/FnlUbp4
vRgLn9NM/PX4ILfe+Vnq9G29/bF+2zYeDBfdvjyk/W190vS7mld4EO9SUV3Z
YopXdNalt8fywLJ4DB+9ZIqFLhvW3fTmgf8fK1TWxpjiF+lqs1LEPJiTHjI2
fZEpzn6fq7d2kAuh/EqemsgUB3o6vnS9ywWt028P5rWLsPGJJ9cM07iQQ09r
c4oT4ZaRn/e9D+NCM/vRu3qJCB9bPMm/cjoXlqz9mBBWYYIDLuRZ5mpwIVJf
be3QahNspOoyvqPREGjXOIvjNU3w84DGuoXnDKG08OGo3nkhzioMz5NFGYLO
rGuM9HlC/JOe7o7xuYbgdTnFhddnjAVrzng+FRjCmFO+6GiyMW4uxYKCXg7s
PP5sAdPWGGdyW/oSijmQElXjnVhvhJdv3UEEJnPAmdF3cSjcCPOqJh/+LogD
Das9/g4yMMJN4gthurYc2G0eYllWKMCZv8ye2fmVDe/v9+oYLxNg/ydtWsX1
bNjet6h08zAf862jXqSeZINrHWvXrQw+bkwwuLJxGxsCrKf4jzjycUZrQZy7
Oxs4xWM/27TwsN+MOT5GbDaMDKwqWLabh3kpHeYfOg2gDvsObBPycGP37tHq
IgNQOes3sreUi49ibk1eogEwS+6tjA3mYr/Mq7m/+BnArC64sInGxdzB+eFL
LAzg74xmS8+ThvjZvC53y1EWaH4KZej9YIiPnNprSK9mwSPO+sDiDg5e9kXw
tjmLBdmxuG1JPAdzfIvuXN3Igitu+dMeSTn4aYHXwQPOLHAeXHbBqoKN0zV6
QlbqsSD/mOOmdWFs7Buc4ODYxoS3kuof49TYmH3LRIN5hQm3DUeLt+Ub4AbG
X01vYpngTvMY+362AU5bv/QieDOhylmzuu41C/uUv4vJEDOhRf9Fsn08C7ON
9ntvHWTAmz5dh0AJCzdESKRz7jLAVPeVuWcZE6fWFA+J0hiw7lrh3HfBTLxU
5vdgOIwBW7uuv/ScYGCDPQNZddMZ0JnESPTKZuAnz5J+PqvBgN2QyP3iyMCy
4AV7Jy5PhotJIx4HLk/G+Yw42WXvyaB9QCXP9Y0+Nisvql4xqA+pouZMulgf
n4ro2aKXpg9d/HyfEn89LJWJOCXT9SF889ODPim6OO/Z0tubGvVAQzzT/2KF
Dpbs3x9sHKUHgmin6pMj2jjPsUStRqAHq/Tji9hW2ljSO3A+ulgXVhZFeLQG
aOGT2eZeVkG60JrrlVH/+yQsXhTw8flXHZgz220ecVMTU7zSgSWu8we2d2go
+KQDTsT9325qayh4pA1RiWfKf5SrK/ijDV4xk7xblqgpeKMNBQyzMdk2VQVf
tGBmbPT5R8l0BU+04Mc+bxxxWgUbk/zQgsu/NXmeuUXD2SQvJoFj8KWHz5O/
IooPkyAm5Z0w9vg4onigCTWOsx6pn/6MqP5rwsrkg1HsnFFE9V0TjgX465sl
DiOq3xpgdbf+YFTQEKL6rAEc92wPodkHRPVXA4xG+r/UNfQjqq/qYLPhV7fP
LX2IT/ZTHZI2zx72b+5GGWQf1aC7N/VZXVYH4pL9U4PImcO3UuXP0VGyb2oQ
vTH0twHTWkT1SxUGuatS4z+eRFSfVEG23sJdWnaPoPqjCr6FX7ZGvG8iqL7Q
4UAi/j5Iu5Og+kGHNwPpUwSz+wiqD3QY0LR54HtqkOCQ+VeBWWMR/W+ODxNU
3lXgXY/3u8iZ44QBmW8anMq8xNGoUQEqzzSoZLbnBSSoA5VfGgyfin+9m6YN
ZmRevxI+r7vX2l2bDFIynxNEmmryD1mPDUBM5nGC0P6p/sSTcgGYkvkbJ/bv
DxRF+kvBlMzbF6LCql+LTfBARObrM/FZEr9++QE2CMk8fSYi0vpra9xZICTz
M0a4tE8Vsd4wwIjMyyjRHOW5ttaEASIyH6PEYXZXtNO+yWBC5mGEUE/qqW36
di0k/R8mXg1nNmQLGGBM+v2JSC7ribes/bYf6e8nYo+n0w2PbiYISD+HiO7Z
jWXr4g2AR/r3kShuWVCxs5EDlF8fCJ2FXR/NQ/lA+fOBSHoYeozeJALKj0Hi
kWFe3qVlU4DizwDhGOMxZ+VtE6D07iduND4NEFwUAIvUt59obt9xYeQfnkLP
94Rtqd32ijAeiEn93hFn+2/tyu3jgQmpVy9xYlAQ/ssRARiT+vQQC+j9C4d6
hSAg9XhL/Buj+v2vpyXAI8/fTZSfqbd5e1gGXPK8XURfwci5wsOmYECer5PI
XTMssPEzARZ5ntdE5x+S5ElaJsAg539FZF+nnxa8FIEeOe9Lwvz268GJdAnw
yflaCfbTfaEzO61ARs7znJBtYbuvj5eAKfn8RiKSmbpYS0cMxuTzGoigxh1H
VaPFICD3f0x0DIjmc+eYgQW5Xy2h4vdSvu6lBUjI9fcJ3bULeuodpcAlv19G
NPDKfqgqkYCUvH+TiDab1rN6oQxk5PVZ4k5YloOf+lSgKV4pXrsamq3MwJy6
j2SfLWpDCDMQU+tR/00ihn/NVrk/Kqxbs9+rQKbY/z6ymmdTv6lCBlbUfIh5
U1gTOCFXzo8OlavtccPmIKTOhyrrDz2me1koz48KcnVt85sslPqgYJcEo6Wx
U2AqpR9iO+zY+OCYNXApfZFuSPJo0cAU4FP6o1eRT/zab00DI8ofFH5xWaNr
iQWYUP6hcx4lFkfyrUFE+Ys+dI9fSHWwVOjXjf53LqU843dL4FP5QL2xtmYb
1eTK/CD6i0HNDWmWij72ou+Oazd191sp84d82S9WXS/7DiRUPpHleK/VyVZr
BR/6URsv66XPv1bKfCNjsffpkgJrZf7R8n7V7Y9XTANDqh9otPZOYa2PXNkf
5OrUofNpp52yXyhiJc17e70dUP9fPqJXba26HlPslP1EQ1GXHqp7ypX9RdWT
z/9RGmALFM8/oRzZCL/HzVbZfyTUW+fcdE+u5AMSNlSNaS63V/ID3b6yZ9YT
azmYUnxBOZG/QmWDPYgp/qA8rdWBB3PkIKH4hHw6mv/Jq5sBUopfyH8kLLWS
YwdmFN+QzWbnvQlz7UBG8Q/tq7wTXpVvD+YUH9GIHB3yu6fUcwKFfT3BScib
ruQr2ven3KXgmYOCDzQ8/6brmrxd9ko+48W1ZTMWudgD9f+Eht22Dd23sZgB
Cr5juthiw+0j9gr9VbDc0KUL2DNA8fuALeK2rGr95KDwg473/rMlMC7UAf4D
2VjucA==
      "]]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], PointSize[0.007333333333333334], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw1lgk4VOsfx8fS2Blmn7GNQZay71f3uFFJKVeKf0QprcrWciOtFEolKgmF
/pQi3FxL3PcXIeVaErqIkiiyLyHx73/OzDzPPPO8z5l5z/v7Lp85PN8AVz9R
EolU+/P9/8+7i1duxaRxITnzqkHtlki03UPP3zeYC663+ZOv/S4g9fznv9rY
cyFDJfNGYVY06pbyUVSicSEvm/HBg3cJ3fGd/fillwPLai0rVN5eRj5P4/96
VsiBR+xLPyY/X0VqNIPoW+c5cCP8zdGkmGuoy/+FZ5A7B3bVnG2OcUtAqVW+
Bmt1OLAmuY33wOkG8lb9QeLNssHLwn+PVVAiUj12s3mmlg3Wn8Le99YloXcN
xpmNSWyYaEvRqPdNQSk6dX/cP8CGXXGOymuV7yLvM7vXnbZlQ8kNr/5l2WlI
pZ2k6iHHBnIVuSrYOwO9M7k9atjFgniHGtd62/+ilIvmlRKPWUCd2xm6YW0W
2tbbcL37FAu2kldb7I56gFRW7N9b5MKC4spBvemFh6jzuvgvV3gsWDfaruNe
kIuSh1Pl9owzobphocXkTR7yWmP9/tdKJqx5c8CyJqQAKd9tLmAkMIEfjmiH
fnmCOmYORg7vYsKVimYnMcO/0O3fJT2qzZmwd4/2vmeuxcgzO10vlfxznWGZ
5vSwFHHFVvw40saA88d2nylYUY7aPdsanO8z4NCSWIfnEoCSngSlax1ngGX9
o6ag+Gdoq5zskR9rGfBnJVpruaoScXZnrmnhMMBt6GpuqXoV+vdvO07OIB0a
gpVaZ3Vr0C1mx9eIMjr4K1eruPrVov8EHkFesXRg71VIjGp7hVi1CtfMvOnQ
fV4q63VkPXrLy94la0iHEYNfj42UNqJboQ6WvYs0uGzFtx3Z8hp5NHdJlTXS
QJ6n92U15w1iLzveGZ9Gg+jezZ9TJVtRWwT18YFgGlwSGS0d0nqLEt/lnLG3
p0Eg5atW2NF25G7h6Mal0SD30zC1Z6ETsa70aE/0UuFFlUsI5Xk3aus/Mfuy
kAr0R53i6X4f0E07Zl36eSr8Vue5W0TuI3K/lZ8a6k4FMQUvb3JHL2KOrwty
1aHCXuoT2/TXfajVqc9eb1YJpihiPlXTn9GNjNMM0ZdK4CiSW2/vNIi2zHO+
/JukBNc/KLjnNAwh+ubCp/kHlMDkXIF3jMMoasnZeDnaVgkstywEv386hq6T
B7bvkFMC6/4rOh+cJ9BmnwhT6y5F+Nv+L/0ns5OIVqxKVnysCI0DllVO5dPo
DaXk7edTihDy+x7VhYQZlLBv00NwUQSZMZEgw7A55FYxFJ7IUwT1/ZEqEnvn
EY0b5RI4ToEnfwxKn/t9Ab0J0eA7VlJAZmviuBSDBPF1ZVNqCRQQr756kjRN
gk1a7i++7aJAe9S08stKEaCeHEtqMKeAfPSGdc0nRKG59eLBLDIF+Gk2Xp08
MdDyWX96IVcBWm73fdpcJAb3KGe0cl0UYOP96ZRGB3HQrCh8uW1cHgJONrWm
NYtDRshAgFyCPPiv7NBQPrgE+Fpq9HJzeehtVBAvYpEhvXVTqX+bHDS2nl23
pZ0MGlFRPsrH5SBEHl425ElAunW5eB1HDpoyqBvI1yVBY3DsQViZLKz8Nzzy
cKgUpCVrb9T3loV9r7eHebpKA2+D52T7ogz4O07XdSjKAMErGbD/PmN+tFgG
CD7JwCfHVZY8V1kgeCQNVPF+ru64LBD8kYY/15N+Wf5ADgjeSMNBuaC0dWHy
QPBFClY9q1hx0FMBCJ5IgY0XW/4wiwLKOD+k4JhfQ0DlYQok47yQhImlVQ3z
VRQg+CAJv6Vw8305ikDwQAKK3wZ0ZoYrAtF/CdgQ4B8xMagIRN8lwKx8YPkS
NyUg+k2G7qxQJ9IjJSD6TAYRQ6o5XYQKRH/JkBy+ryfOjwpEX5cAh+QfEdhM
BTbezyWgc5o2b25Gg0S8j+KQj22yyYuhARPvnzhox8WWnR2hwU28b+IQ0ed1
odaLDkS/xGA4Mni+u4QORJ/EIGDlttWLTAYQ/RED2jrbSO/zDCD6IgovSnVp
Ep8ZQPRDFDZJfIzNc2QC0QdRmNHuOsosZgIdz78I8L3sI81YLCDyLgKToRdE
/c/95C6ebxLIxt05+mCIJcgzCdhWNj+c3diC/JIgO4JPKnrOBk08r4voXUUL
bdsyDvDxfC6gsZ6eb9vvcICH53EBTc4tJmfKcEEdz98PdJPxlD518ucaz9s8
iizJZz6d4IIanq/vSG3l3Vf5fsqggufpO8r3qhPz6Pm5xvMzh5Y3Ozt0eqoA
F8/LLDqhun2+uVUF1PB8zKL6Y0vzrbaqgiqehxkk5VB9VPODKqjg/n9DvYst
2lb71EAZ93safR065vx1Ug24uL/TqJIyGWJqrw4c3M8p5K/07a3OFXVg4f5N
IscdcZdPdqkL/JpApvfCfa8Y8wT+TCDZ1V1VpGiewI9xpHKY7pr0iQcEf8ZQ
mNyR0Zg1GgK9R9H4iuQOhVwNUML1HUVjw/tnzLh8gZ7DaJXunDI7gQ88XL8h
5Fx8yvMIVRNUcb0G0Yi69OLwXU1QxvUZQANfpyRsbLSAg+vxBbnkyYgzB7SA
hc/fj75aGBXdz9YGJj5vH4qelPmWELUUqPh8vWhFkrurTZwOKOHzfERRH1Pi
r73WBQp+/g9oJKVkcKevPsjh532PKqhzsi/clgMbP987FEkeC2unGIIWfp52
JD8geXfn2HJQx+/fhtx1M3piDy8DZfx+b1BcyyqPxlB94OD7N6ETskfC33fo
gQ6+3z+omDriseOoHmjgv69BSerNZ31W6wET//4zVJqy4WKggx7w8etFKOfg
8Ezbfj3QwtdZKMTZybasTA9Igpcjb/9Qq70+aBPXMfFLhg5LJZcBj/g9VtH1
trJAdblwf+wa/97e+DIDwf41mGpqMYpJMwJ94nyYWFF/oc1mE+H5sZCm7rU7
m41AhZgPC14a4fvhuaFwfuzh2cC+9d0GQn0whWqFmRc3DUCX0A+j3WqS+/uV
ATAJfbH8rqSnlhcNgU3oj01kcTpFo42AS/iD3ZJ4rWG7aAyqhH9YspfL+y9x
pqBG+IsNBmqWbLloLNCvH+MnrLZiNxkBm8gHVt2VdSDgsZEwP5hX6tR3V7qx
oI+D2HCc2KFmUxNh/rA9mpLSNS1moEHkE9uY+E+cxHUTAR9GsYaYHawX5cbC
fGOFLhHUvC5jYf6xw56JHYoKpsAg+oHF1uhbZcabC/uDGaQdN036bCLsFyZa
fl88MNIEiOeXSey4akLKjUumwn5iuywOB4GMhbC/2M0Nn+/sdDcV8HwaW/PR
IEEhwFTYfyy9o6NgY4aFkA/YsXvOF5g6ZkJ+YNnGEl05o6agTvAFS3H6FHvV
2xJ4BH+welb6HpfdP+cn+ISVTLpdZUqYA5/gF3YuZ3Oe4og5aBJ8w0S+rI+I
bTIDLYJ/WHzCVUUlIyvQJviIcXToO4dZ5gI9F7A+7tCOH47WQr5i+kUpL91P
mAv4QLJ7FDLpV/mblZDPdlaHRFZaS1sA8XxCsks9SSsgP7MQ8t1uKtl956tW
S4H+InZJsx1zj3wthP8PdoxSl6BNNywFfojaZXSJZBnRrOF/G40nGg==
      "]]}, 
    {RGBColor[0.922526, 0.385626, 0.209179], PointSize[0.007333333333333334], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw1lgk4VPsbx4cw1NCYGbNnzJiRrZF1QnXmUtfVdhXithApiUq5baoboVQ3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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-7.295517004712021, -30.137483017485994`},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{
     Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
      15.954589770191003`, RotateLabel -> 0], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {
     Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
      15.954589770191003`, RotateLabel -> 0], 
     Charting`ScaledFrameTicks[{Log, Exp}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{498.73046875, Automatic},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-7.295517004712021, 2.302585092994046}, {-30.137483017485994`, 
   9.903354217425003}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{
     Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
      15.954589770191003`, RotateLabel -> 0], 
     Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
      15.954589770191003`, RotateLabel -> 0]}, {{{-6.907755278982137, 
       FormBox["0.001`", TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.010\"", ShowStringCharacters -> False], 
          0.01`15.954589770191003, AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
       0.}}, {-2.3025850929940455`, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.100\"", ShowStringCharacters -> False], 
          0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}}, {0., 
       FormBox["1", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}}, {-9.210340371976182, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-8.517193191416238, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-8.111728083308073, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.824046010856292, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.600902459542082, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.418580902748128, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.264430222920869, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.1308988302963465`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.013115794639964, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-6.214608098422191, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.809142990314028, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.521460917862246, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.298317366548036, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.115995809754082, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.961845129926823, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.8283137373023015`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.710530701645918, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.912023005428146, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.506557897319982, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.2188758248682006`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.995732273553991, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.8134107167600364`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.659260036932778, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.5257286443082556`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.4079456086518722`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.6094379124341003`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.2039728043259361`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.916290731874155, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.6931471805599453, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.5108256237659907, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.35667494393873245`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.2231435513142097, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.10536051565782628`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.6931471805599453, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0986122886681098`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.3862943611198906`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.6094379124341003`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.791759469228055, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.9459101490553132`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.0794415416798357`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.1972245773362196`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.995732273553991, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.4011973816621555`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.6888794541139363`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.912023005428146, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.0943445622221, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.248495242049359, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.382026634673881, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.499809670330265, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.605170185988092, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}}, {{-20.72326583694641, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "9"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}}, {-9.210340371976182, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}}, {-32.23619130191664, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-29.933606208922594`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-27.631021115928547`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-23.025850929940457`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-18.420680743952367`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-16.11809565095832, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-11.512925464970229`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-6.907755278982137, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.605170185988091, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {0., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.605170185988092, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.907755278982137, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      11.512925464970229`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      13.815510557964274`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      13.9108207377686, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      13.997832114758229`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      14.077874822431765`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      14.151982794585487`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      14.22097566607244, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}}}]]], "Output",
 CellChangeTimes->{
  3.889002010103619*^9, {3.889002048743997*^9, 3.8890020607966843`*^9}, 
   3.889060281076693*^9, 3.889064554959045*^9, 3.889080109628345*^9, {
   3.889080334272502*^9, 3.8890803406419153`*^9}, 3.8890804001464043`*^9, 
   3.8890804336438313`*^9, 3.8890805262295322`*^9, {3.889080570745016*^9, 
   3.889080637481906*^9}, {3.889080681845907*^9, 3.8890806917465143`*^9}, {
   3.8890808090608883`*^9, 3.889080812799999*^9}, {3.889080881737143*^9, 
   3.889080901787978*^9}, {3.889080980578001*^9, 3.889081001418297*^9}, 
   3.8890813818351173`*^9, 3.8890816263012667`*^9, 3.889081657363613*^9, 
   3.889081786692127*^9, 3.889084371125387*^9, 3.889499987326635*^9, 
   3.9020354681504498`*^9, 3.9020355947885714`*^9, 3.9020356276680098`*^9, {
   3.902035893631892*^9, 3.9020359209569464`*^9}, 3.9020365143569345`*^9, 
   3.902036723440879*^9, 3.9020432634419775`*^9, 3.9034205055700016`*^9, 
   3.9040135598722134`*^9, 3.9040343951566777`*^9, 3.904110296571024*^9, 
   3.904115475396166*^9, 3.904116085763728*^9, 3.904116418606583*^9, 
   3.9041259539306536`*^9, 3.9041260032015777`*^9, 3.9041861486507826`*^9},
 CellLabel->
  "Out[678]=",ExpressionUUID->"ef06c935-c07a-4e38-adf8-d6449efc4532"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw1lgk4VOsfx8fS2Blmn7GNQZay71f3uFFJKVeKf0QprcrWciOtFEolKgmF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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-7.295517004712021, -27.263004775487694`},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"P(\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\))\"", 
       HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->FrontEndValueCache[{{
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}}, {{{{-25.328436022934504`, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "11"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
          TraditionalForm], {0.01, 0.}}, {-20.72326583694641, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "9"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm], {0.01, 0.}}, {-16.11809565095832, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "7"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm], {0.01, 0.}}, {-11.512925464970229`, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm], {0.01, 0.}}, {-6.907755278982137, 
        FormBox["0.001`", TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.100\"", ShowStringCharacters -> False], 
           0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-29.933606208922594`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-27.631021115928547`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-23.025850929940457`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-18.420680743952367`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-13.815510557964274`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-25.328436022934504`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-20.72326583694641, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-16.11809565095832, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-11.512925464970229`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-29.933606208922594`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-27.631021115928547`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-23.025850929940457`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-18.420680743952367`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-13.815510557964274`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}}, {{{-6.907755278982137, 
        FormBox["0.001`", TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
        
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.010\"", ShowStringCharacters -> False], 
           0.01`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.100\"", ShowStringCharacters -> False], 
           0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.111728083308073, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.824046010856292, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.418580902748128, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.264430222920869, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.1308988302963465`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.013115794639964, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.111728083308073, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.824046010856292, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.418580902748128, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.264430222920869, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.1308988302963465`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.013115794639964, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{498.73046875, Automatic},
  LabelStyle->{FontSize -> 18, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-7.295517004712021, 
   2.302585092994046}, {-27.263004775487694`, -0.010419437154342952`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.889002010103619*^9, {3.889002048743997*^9, 3.8890020607966843`*^9}, 
   3.889060281076693*^9, 3.889064554959045*^9, 3.889080109628345*^9, {
   3.889080334272502*^9, 3.8890803406419153`*^9}, 3.8890804001464043`*^9, 
   3.8890804336438313`*^9, 3.8890805262295322`*^9, {3.889080570745016*^9, 
   3.889080637481906*^9}, {3.889080681845907*^9, 3.8890806917465143`*^9}, {
   3.8890808090608883`*^9, 3.889080812799999*^9}, {3.889080881737143*^9, 
   3.889080901787978*^9}, {3.889080980578001*^9, 3.889081001418297*^9}, 
   3.8890813818351173`*^9, 3.8890816263012667`*^9, 3.889081657363613*^9, 
   3.889081786692127*^9, 3.889084371125387*^9, 3.889499987326635*^9, 
   3.9020354681504498`*^9, 3.9020355947885714`*^9, 3.9020356276680098`*^9, {
   3.902035893631892*^9, 3.9020359209569464`*^9}, 3.9020365143569345`*^9, 
   3.902036723440879*^9, 3.9020432634419775`*^9, 3.9034205055700016`*^9, 
   3.9040135598722134`*^9, 3.9040343951566777`*^9, 3.904110296571024*^9, 
   3.904115475396166*^9, 3.904116085763728*^9, 3.904116418606583*^9, 
   3.9041259539306536`*^9, 3.9041260032015777`*^9, 3.9041861578570895`*^9},
 CellLabel->
  "Out[679]=",ExpressionUUID->"5de81041-f061-42d6-8164-361309baf179"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw1lgk4lGsbx8fSWDIZM2N2xgxji+xLp/Qq7QttqKMoldMRiT6lnEJFTudr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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-7.295517004712021, -26.41061195899314},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"P(\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\))\"", 
       HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->FrontEndValueCache[{{
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}}, {{{{-25.328436022934504`, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "11"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
          TraditionalForm], {0.01, 0.}}, {-20.72326583694641, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "9"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm], {0.01, 0.}}, {-16.11809565095832, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "7"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm], {0.01, 0.}}, {-11.512925464970229`, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm], {0.01, 0.}}, {-6.907755278982137, 
        FormBox["0.001`", TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.100\"", ShowStringCharacters -> False], 
           0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-27.631021115928547`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-26.937873935368604`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-26.53240882726044, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-26.244726754808656`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-26.021583203494448`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-25.839261646700493`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-25.685110966873236`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-25.551579574248713`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-25.43379653859233, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-23.025850929940457`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-18.420680743952367`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-13.815510557964274`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-25.328436022934504`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-20.72326583694641, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-16.11809565095832, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-11.512925464970229`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-27.631021115928547`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-26.937873935368604`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-26.53240882726044, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-26.244726754808656`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-26.021583203494448`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-25.839261646700493`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-25.685110966873236`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-25.551579574248713`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-25.43379653859233, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-23.025850929940457`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-18.420680743952367`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-13.815510557964274`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}}, {{{-6.907755278982137, 
        FormBox["0.001`", TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
        
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.010\"", ShowStringCharacters -> False], 
           0.01`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.100\"", ShowStringCharacters -> False], 
           0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.111728083308073, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.824046010856292, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.418580902748128, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.264430222920869, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.1308988302963465`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.013115794639964, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.111728083308073, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.824046010856292, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.418580902748128, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.264430222920869, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.1308988302963465`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.013115794639964, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{498.73046875, Automatic},
  LabelStyle->{FontSize -> 18, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-7.295517004712021, 
   2.302585092994046}, {-26.41061195899314, -0.07261080024048347}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.889002010103619*^9, {3.889002048743997*^9, 3.8890020607966843`*^9}, 
   3.889060281076693*^9, 3.889064554959045*^9, 3.889080109628345*^9, {
   3.889080334272502*^9, 3.8890803406419153`*^9}, 3.8890804001464043`*^9, 
   3.8890804336438313`*^9, 3.8890805262295322`*^9, {3.889080570745016*^9, 
   3.889080637481906*^9}, {3.889080681845907*^9, 3.8890806917465143`*^9}, {
   3.8890808090608883`*^9, 3.889080812799999*^9}, {3.889080881737143*^9, 
   3.889080901787978*^9}, {3.889080980578001*^9, 3.889081001418297*^9}, 
   3.8890813818351173`*^9, 3.8890816263012667`*^9, 3.889081657363613*^9, 
   3.889081786692127*^9, 3.889084371125387*^9, 3.889499987326635*^9, 
   3.9020354681504498`*^9, 3.9020355947885714`*^9, 3.9020356276680098`*^9, {
   3.902035893631892*^9, 3.9020359209569464`*^9}, 3.9020365143569345`*^9, 
   3.902036723440879*^9, 3.9020432634419775`*^9, 3.9034205055700016`*^9, 
   3.9040135598722134`*^9, 3.9040343951566777`*^9, 3.904110296571024*^9, 
   3.904115475396166*^9, 3.904116085763728*^9, 3.904116418606583*^9, 
   3.9041259539306536`*^9, 3.9041260032015777`*^9, 3.904186158392136*^9},
 CellLabel->
  "Out[680]=",ExpressionUUID->"41557169-a18f-480b-986f-f0e7813ee264"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.007333333333333334], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw1lgk4VPsbx22NdTLGMIt1THayr9N1lJKWi6tEke3eqwU3iq6S9lTkulnK
UkTRZr1Zi/t7qSzlksgWkTWkpCJb/v3PmZnnmWee3/Ob8zvv+32/3885bL8D
Lr8LCQgINPz4/v/3xnJcSnSmAvjl30tdKP8H+bjrBPodVICB8soYxaBipFr0
xMbaTgEOXvqDVGJfivrEvWWoNAXYYW68eMOhHGX4zQ2ODbGgqzfbZyTsIfJ+
lFBaXcKCR1mTN0taKpEKbfXFlCgW/PxybGSfN0JvAus9QtxY8Pd8UPB6mWqU
/tRv9SYtFpikMC1842qQl/KSAHuOCRdWr+uf1X2ClP+82vqtgQnazlSa+NhT
1NtslPMilQmOCdzyO/V16LpWY/idACbMyHgNLTY2IK9T/ltOrmHCrV2iqWu+
PUdK3QLK7mQm7IlSssnf2oR6jdOmDN4wIGJcYszF/wW6HmP2WLSAAT47voat
rWpBu4eak/pOMIBbY2DupteKlH7av7fMmQGtdX1zz4vbUE+SCDeOzYBtG6ej
u9za0bUP6eQ903TIvHpE86F8J/LcaNVv85gOvcqBvTnTXUjxRus/8ol0GLtC
b3j1/jV6/S3o3Iff6JCWP2ERTnqD0n4Rc681o0PUp1p3T9V+5HEvSyedRAeH
3KpQT8e3SEH4p6WwDnnYMDz+X13sAOr26Gj++Y48DO7W1+P0DaLU4pAs9SPy
8OvwkYyJdcNoF1kqbGmTPNSkv3NPqhhBLP+cja9Y8vBI+r+T0XbvUNe/tqy8
CTmY3HNUSuftGEqhv35/tlIOyLdrrtTGT6CdwWHIM1YOYjCwyXafRIwG6XhT
LzlYoU65vGj8EXWy7/0mZSAHH7maMPf3FEo5ut5iaJkGLr+YWr2I/4TcW9+I
V76gwRavRFORjGnE1DvSk5BJA/eyNI24ks+o46xsQcBBGsTYtxr5tn9Byb15
p+zsaLBubt+Cj+AMcjN32K5Ao8FY8/L1APNZxIgb0Pg8JAvR1Qloe9g31DF6
bO5ZiSzoDVg3j1TNoau29MasKFk4EdH8x6D0AnJLKUo/6iYLQeeHJEUCFhF9
ekuIi5YsfLCbvDvftITaN4/Y6cxRYagqr/cgdxlduXlSXugZFeos+iPE3QVg
xyJrrCuVCt715bk28oIg51ryqCiACitvuc5odQrCqzynvy6uoUJJXF331etC
kEQa9/ElU6Eo77SVh78wuHqfNbF6IwNPAm+y1xuLAK1cmSRTIAPWnbKZ6oIr
oI1S0fnuhAzoP5C/9OrlCkjct+0+OMtA4062lf5tEmyvmYxMZsuAif1hPYnj
okBTuOAcPE2B3OM2eY5uYtB2SI3j8JgCnzet5w4Yi0NCY+VXlUQK1Id5dhdR
JGCbulv97G8UiOH4axdOSYDs8U+pzWYUUJnutH31UhJa22OCbpMocDme46Nc
JgXq3ltPfs+XBs89LpGx18lwi3JKPd9ZGrTOGzVrRa2EVTUlz3ZPr4RU13rv
+WBpuHlo/AA5cSUUufY0iRpQgKOuIldlthKidmrvrcyhQFb7toeBHWQ4N+e6
+paKDKhduOCteIQMzru3LNSnyECWVZVII4sMnO0MATM5KqhNfLobUSkFtc3Z
N6YvUyHzmoaTrpcUyCXH+kpRZIHt6PGle1kSohOniy/FyQLBK0noJoXkRFJo
QPBJEpZF2wvfxdOA4JEEhCQZv22XlwOCPxJwwnJpxPmaHBC8kYDiU4LPvTjy
QPBFHLL+yGwWzZUHgifi4HXH/qmLOR0UcX6Ig7vIPZJ9DR2u4bwQg77Eh6xR
JwYQfBCDKg6VxO1jAMEDUcjuFAq0D2YCkX9RGM5dkCMLs4DIuygwOib3xl9l
AZFvEszM/Grdpa8ARJ5JEBCakzz4VAGI/JJA6FmrzQNvRSDyugJaopxmHBYU
gYnncwVUVJ0wzE5WgmQ8jyLwpkHTr85CGeh4/kSg2qQyMb9TGa7ieROBEfaB
BvcIFSDyJQx/Su599FZaFYg8CYPBpbK4r36qQORHGB7PKjwYLlUFIi9CYHbg
ZkqBJJuXDyFANA9DZ182Lw9C0Kmc+e5x2Y993P+CkBKmU0OSVuP5XRB2nctZ
Q9ujBrK4vwXgtB44jSI1np8FIMldLPAok8PzrwC8nOuMqDvEgVW4X5dR2FTB
QF0TBzi4P78jseHSY6E6q4CN+/E70r8ulfE0ahWo4v5bQrMPTZkPBn+scb8t
ojZ6v7XpWnVQwf21gCSzHN9iGeqghPtpAZ1x+CeicenHGvfPPHJse7Lc7KkB
Crhf5tC17EKGbaUGqOD+mEN+XGc2VVETlHE/fEOjZq8tucc0QQmf/ywqDP/4
S2GPJiji855B3YVd3v4/aYECPt8ZZKMt7OSSrgUsfJ5fkTAzTn/fshYw8Pl9
QVzXvs03fLR58/qMhkOSnSertXnz+YxQSssue44Obx7TKKk2m5x1VofHn0+I
1tNfPTusw9N7CnkV3Y3DNuoCFdd3Cil6ju84eEeXp+cHRG3Q774orgdsXL9J
9G9w5MuT+/VAGddrAmFBGQMuz/VAEddnHOlZl6Uv6uoDC9djDN1fup0QcUkf
GHj/o2iwYsag6b0+0PF+R9BBBW7F562rQRbvbwiF6kRveJ+7Gqh4P4PI//Hm
wnIpA6Dg9b9FZoa2x3YFGgAZr7cfSV6xaGp9bgBMvL5epDjxIS1BzhDU8Xq6
kWFW2aTuBkNQxe/fgRIkjBOKQw1BEb9fG1qre2OvwS1DYOHntyCRhBVB6a2G
oIWf9x+CjK4CYWEjUMOvr0MXWjKcfY2NgI7/vxqd/nMsuMLXCDj4fhmSORRj
uvKyEajj69vo976kAl8wAgHeZzE8bqTkoxFoEPuY47lLdVIqxsAmrsekz9jo
7HU05p+PvT5t1NAQacw7vw7DNsaYm+QZgy5RHxaeeWYgu8eYXz92t1KHwZEy
ASWiP+ycyrXp+1wTfv/Y+ZvjAWsDTPj6YBVDZZuGUk1Am9AP69jfoJn0zATo
hL4Y5l5yZPu8CTAJ/bGK8G3H1HRMQYGYD9aZdNZheacpKBPzw6Zvl9aOXzQF
FWK+mFiW2L2hClOefqNYiPvxY+/HTIFJ+AM7O9qcKsgy4/sH69gjpcnZbMbL
4wTmZHJe1fmoGd9/WNH5fKfz98xAjfAnplYk6VTXbcbjwxR28Zlu/EpJc76/
sf1/t/3qwTXn+x+rHdzddT/AHOSJfGDW3wWnltLM+fnB9Ksnjzs1mvPzhZUe
djBLXzQH4v3lC0Z7EHp3VM+Cn08s1pC0Q3u3BT+/2MkXCVd8Yi14PJ/B+gcP
P4qusuDnH5sf/kske9KCzwfsVkV7eq6SJZ8fmHHaX1XpP1uCKsEXbHlHb2x4
pCWwCf5gs012LhZ5lqBG8AlruXjIu7PHEjgEvzDxyY9WO6WsYBXBNywZOSWU
ca1AneAflv5a1vvTfivQIPiIpRwOGBJJteLp+R1zHS/qnKq34vMVoz9dcCme
teLxQcA288HDIUcNaz6fbQNLf8+F7da89xMB23VLbQ4SZ6z5fLftiJgf0Cuy
5ukvaLu8qpat02fNfz7YjmzNMhchc3nzELINjTyTX2XNhf8BhVc+nA==
      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], PointSize[0.007333333333333334], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw1lgk4lNsfx2fs+zb7DGYGI1tZx3bLmW7+JBWtFEVyi1uS62ovKi0uLpUS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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-7.295517004712021, -29.52703035010737},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"P(\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\))\"", 
       HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->FrontEndValueCache[{{
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}}, {{{{-23.025850929940457`, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "10"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
          TraditionalForm], {0.01, 0.}}, {-13.815510557964274`, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.01\"", ShowStringCharacters -> False], 
           0.01`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 
        0.}}, {-32.23619130191664, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-29.933606208922594`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-27.631021115928547`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-25.328436022934504`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-20.72326583694641, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-18.420680743952367`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-16.11809565095832, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-11.512925464970229`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-23.025850929940457`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-13.815510557964274`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-32.23619130191664, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-29.933606208922594`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-27.631021115928547`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-25.328436022934504`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-20.72326583694641, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-18.420680743952367`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-16.11809565095832, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-11.512925464970229`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}}, {{{-6.907755278982137, 
        FormBox["0.001`", TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
        
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.010\"", ShowStringCharacters -> False], 
           0.01`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.100\"", ShowStringCharacters -> False], 
           0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.111728083308073, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.824046010856292, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.418580902748128, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.264430222920869, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.1308988302963465`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.013115794639964, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.111728083308073, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.824046010856292, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.418580902748128, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.264430222920869, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.1308988302963465`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.013115794639964, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{498.73046875, Automatic},
  LabelStyle->{FontSize -> 18, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-7.295517004712021, 2.302585092994046}, {-29.52703035010737, 
   2.130376020567997}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.889002010103619*^9, {3.889002048743997*^9, 3.8890020607966843`*^9}, 
   3.889060281076693*^9, 3.889064554959045*^9, 3.889080109628345*^9, {
   3.889080334272502*^9, 3.8890803406419153`*^9}, 3.8890804001464043`*^9, 
   3.8890804336438313`*^9, 3.8890805262295322`*^9, {3.889080570745016*^9, 
   3.889080637481906*^9}, {3.889080681845907*^9, 3.8890806917465143`*^9}, {
   3.8890808090608883`*^9, 3.889080812799999*^9}, {3.889080881737143*^9, 
   3.889080901787978*^9}, {3.889080980578001*^9, 3.889081001418297*^9}, 
   3.8890813818351173`*^9, 3.8890816263012667`*^9, 3.889081657363613*^9, 
   3.889081786692127*^9, 3.889084371125387*^9, 3.889499987326635*^9, 
   3.9020354681504498`*^9, 3.9020355947885714`*^9, 3.9020356276680098`*^9, {
   3.902035893631892*^9, 3.9020359209569464`*^9}, 3.9020365143569345`*^9, 
   3.902036723440879*^9, 3.9020432634419775`*^9, 3.9034205055700016`*^9, 
   3.9040135598722134`*^9, 3.9040343951566777`*^9, 3.904110296571024*^9, 
   3.904115475396166*^9, 3.904116085763728*^9, 3.904116418606583*^9, 
   3.9041259539306536`*^9, 3.9041260032015777`*^9, 3.904186158961243*^9},
 CellLabel->
  "Out[681]=",ExpressionUUID->"c9c13785-c8b5-44e0-8051-d4fbf23b71c4"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.007333333333333334], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw9lnk4VesXx49zjpPpOPuYhwhRbpQGQ0ptJYkGFS6ZQ35KIq4r85BEFImL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      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], PointSize[0.007333333333333334], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw1lXk4VXsXx7dzOIbD2fuYHeNRIpJyDRFtUSlNChkjcsusclFd81CK1HXN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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-7.2705523451534315`, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Slope\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->FrontEndValueCache[{{Automatic, Automatic}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}}, {{
     Automatic, Automatic}, {{{-6.907755278982137, 
        FormBox["0.001`", TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
        
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.010\"", ShowStringCharacters -> False], 
           0.01`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.100\"", ShowStringCharacters -> False], 
           0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.111728083308073, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.824046010856292, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.418580902748128, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.264430222920869, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.1308988302963465`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.013115794639964, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.111728083308073, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.824046010856292, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.418580902748128, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.264430222920869, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.1308988302963465`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.013115794639964, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{498.73046875, Automatic},
  LabelStyle->{FontSize -> 18, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-7.2705523451534315`, 
    2.2795592420641055`}, {-4.378403046737399, 0}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.02]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], Automatic}]], "Output",
 CellChangeTimes->{
  3.889002010103619*^9, {3.889002048743997*^9, 3.8890020607966843`*^9}, 
   3.889060281076693*^9, 3.889064554959045*^9, 3.889080109628345*^9, {
   3.889080334272502*^9, 3.8890803406419153`*^9}, 3.8890804001464043`*^9, 
   3.8890804336438313`*^9, 3.8890805262295322`*^9, {3.889080570745016*^9, 
   3.889080637481906*^9}, {3.889080681845907*^9, 3.8890806917465143`*^9}, {
   3.8890808090608883`*^9, 3.889080812799999*^9}, {3.889080881737143*^9, 
   3.889080901787978*^9}, {3.889080980578001*^9, 3.889081001418297*^9}, 
   3.8890813818351173`*^9, 3.8890816263012667`*^9, 3.889081657363613*^9, 
   3.889081786692127*^9, 3.889084371125387*^9, 3.889499987326635*^9, 
   3.9020354681504498`*^9, 3.9020355947885714`*^9, 3.9020356276680098`*^9, {
   3.902035893631892*^9, 3.9020359209569464`*^9}, 3.9020365143569345`*^9, 
   3.902036723440879*^9, 3.9020432634419775`*^9, 3.9034205055700016`*^9, 
   3.9040135598722134`*^9, 3.9040343951566777`*^9, 3.904110296571024*^9, 
   3.904115475396166*^9, 3.904116085763728*^9, 3.904116418606583*^9, 
   3.9041259539306536`*^9, 3.9041260032015777`*^9, 3.9041861595660315`*^9},
 CellLabel->
  "Out[682]=",ExpressionUUID->"869ba2a8-7164-41e7-a1b1-fea89113033c"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw9Vnk8VWsXPqbDMW7OcXBMyXhDiiihrXRFtwFxUaakUkQln5QxQ0mpRMiQ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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-7.2705523451534315`, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Slope\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->FrontEndValueCache[{{Automatic, Automatic}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}}, {{
     Automatic, Automatic}, {{{-6.907755278982137, 
        FormBox["0.001`", TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
        
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.010\"", ShowStringCharacters -> False], 
           0.01`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.100\"", ShowStringCharacters -> False], 
           0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.111728083308073, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.824046010856292, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.418580902748128, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.264430222920869, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.1308988302963465`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.013115794639964, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.111728083308073, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.824046010856292, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.418580902748128, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.264430222920869, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.1308988302963465`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.013115794639964, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{498.73046875, Automatic},
  LabelStyle->{FontSize -> 18, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-7.2705523451534315`, 
    2.2795592420641055`}, {-4.139380966839854, 0}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.02]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], Automatic}]], "Output",
 CellChangeTimes->{
  3.889002010103619*^9, {3.889002048743997*^9, 3.8890020607966843`*^9}, 
   3.889060281076693*^9, 3.889064554959045*^9, 3.889080109628345*^9, {
   3.889080334272502*^9, 3.8890803406419153`*^9}, 3.8890804001464043`*^9, 
   3.8890804336438313`*^9, 3.8890805262295322`*^9, {3.889080570745016*^9, 
   3.889080637481906*^9}, {3.889080681845907*^9, 3.8890806917465143`*^9}, {
   3.8890808090608883`*^9, 3.889080812799999*^9}, {3.889080881737143*^9, 
   3.889080901787978*^9}, {3.889080980578001*^9, 3.889081001418297*^9}, 
   3.8890813818351173`*^9, 3.8890816263012667`*^9, 3.889081657363613*^9, 
   3.889081786692127*^9, 3.889084371125387*^9, 3.889499987326635*^9, 
   3.9020354681504498`*^9, 3.9020355947885714`*^9, 3.9020356276680098`*^9, {
   3.902035893631892*^9, 3.9020359209569464`*^9}, 3.9020365143569345`*^9, 
   3.902036723440879*^9, 3.9020432634419775`*^9, 3.9034205055700016`*^9, 
   3.9040135598722134`*^9, 3.9040343951566777`*^9, 3.904110296571024*^9, 
   3.904115475396166*^9, 3.904116085763728*^9, 3.904116418606583*^9, 
   3.9041259539306536`*^9, 3.9041260032015777`*^9, 3.904186160095716*^9},
 CellLabel->
  "Out[683]=",ExpressionUUID->"b9b58c7f-d954-436d-9a35-03d058b30337"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "convert", " ", "mu_x", " ", "and", " ", "sigma_x", " ", "vs", " ", "mu", 
    " ", "and", " ", "sigma"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"EstimateMu", "[", 
     RowBox[{"mux_", ",", "sigmax_"}], "]"}], ":=", " ", 
    RowBox[{"1.", " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"mux", "^", "2"}], "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"mux", "^", "2"}], " ", "+", " ", 
         RowBox[{"sigmax", "^", "2"}]}], "]"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"EstimateSigma", "[", 
     RowBox[{"mux_", ",", " ", "sigmax_"}], "]"}], ":=", 
    RowBox[{"1.", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"Log", "[", 
       RowBox[{"1", " ", "+", " ", 
        RowBox[{
         RowBox[{"sigmax", "^", "2"}], "/", 
         RowBox[{"mux", "^", "2"}]}]}], "]"}], "]"}]}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"EstimateMu", "[", 
    RowBox[{"250", ",", "10"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"EstimateSigma", "[", 
    RowBox[{"250", ",", "10"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"EstimateMu", "[", 
    RowBox[{"250", ",", "250"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"EstimateSigma", "[", 
    RowBox[{"300", ",", "205"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.904187513688132*^9, 3.9041876039880114`*^9}, {
  3.904187653771544*^9, 3.9041876715746946`*^9}, {3.904187707307971*^9, 
  3.904187879638977*^9}, {3.9041879197674084`*^9, 3.9041879342178183`*^9}, {
  3.904187969810813*^9, 3.9041879899019427`*^9}, {3.904188067846054*^9, 
  3.904188071783946*^9}, {3.9041881287470827`*^9, 3.904188131018881*^9}, {
  3.904190045834504*^9, 3.904190053733157*^9}, {3.9041901119643707`*^9, 
  3.904190119617751*^9}, {3.9041901633681464`*^9, 3.9041901728146105`*^9}, {
  3.904190227216575*^9, 3.904190260716491*^9}, {3.904719883844332*^9, 
  3.9047199023415794`*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"ada8b3f5-d293-4a14-a0eb-400f1f7504a1"],

Cell[BoxData["5.520661557180397`"], "Output",
 CellChangeTimes->{{3.9041878285706854`*^9, 3.9041878806855545`*^9}, 
   3.904187936409606*^9, {3.904187977531421*^9, 3.904187990963075*^9}, 
   3.904188072547146*^9, 3.9041881313472977`*^9, 3.904190056689168*^9, {
   3.9041901156058207`*^9, 3.9041901202442627`*^9}, 3.904190173605768*^9, {
   3.904190246732086*^9, 3.904190262096056*^9}, 3.9046434965255637`*^9, 
   3.9047199035306025`*^9, 3.907145168699089*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"970ca17b-e104-4963-ba99-4dd3ccc720d4"],

Cell[BoxData["0.039984013851751724`"], "Output",
 CellChangeTimes->{{3.9041878285706854`*^9, 3.9041878806855545`*^9}, 
   3.904187936409606*^9, {3.904187977531421*^9, 3.904187990963075*^9}, 
   3.904188072547146*^9, 3.9041881313472977`*^9, 3.904190056689168*^9, {
   3.9041901156058207`*^9, 3.9041901202442627`*^9}, 3.904190173605768*^9, {
   3.904190246732086*^9, 3.904190262096056*^9}, 3.9046434965255637`*^9, 
   3.9047199035306025`*^9, 3.907145168716027*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"5d45414b-a390-4aef-9e1c-f44b5a05a768"],

Cell[BoxData["5.174887327582274`"], "Output",
 CellChangeTimes->{{3.9041878285706854`*^9, 3.9041878806855545`*^9}, 
   3.904187936409606*^9, {3.904187977531421*^9, 3.904187990963075*^9}, 
   3.904188072547146*^9, 3.9041881313472977`*^9, 3.904190056689168*^9, {
   3.9041901156058207`*^9, 3.9041901202442627`*^9}, 3.904190173605768*^9, {
   3.904190246732086*^9, 3.904190262096056*^9}, 3.9046434965255637`*^9, 
   3.9047199035306025`*^9, 3.907145168724985*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"53bc9636-4eb3-43af-8731-e05230f114bb"],

Cell[BoxData["0.6190166623466058`"], "Output",
 CellChangeTimes->{{3.9041878285706854`*^9, 3.9041878806855545`*^9}, 
   3.904187936409606*^9, {3.904187977531421*^9, 3.904187990963075*^9}, 
   3.904188072547146*^9, 3.9041881313472977`*^9, 3.904190056689168*^9, {
   3.9041901156058207`*^9, 3.9041901202442627`*^9}, 3.904190173605768*^9, {
   3.904190246732086*^9, 3.904190262096056*^9}, 3.9046434965255637`*^9, 
   3.9047199035306025`*^9, 3.9071451687330604`*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"4e654d23-cc8b-4ed1-959a-967e39e4ead5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"plotFormFactors", " ", "=", " ", 
  RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"qlist", ",", 
         RowBox[{"P11", "[", 
          RowBox[{"qlist", ",", "250", ",", "10"}], "]"}]}], "}"}], 
       "\[Transpose]"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"calculateIntensitiesLR", "[", 
        RowBox[{
         RowBox[{"EstimateMu", "[", 
          RowBox[{"10", ",", "1"}], "]"}], ",", 
         RowBox[{"EstimateSigma", "[", 
          RowBox[{"10", ",", "1"}], "]"}], ",", 
         RowBox[{"EstimateMu", "[", 
          RowBox[{"250", ",", "10"}], "]"}], ",", 
         RowBox[{"EstimateSigma", "[", 
          RowBox[{"250", ",", "10"}], "]"}]}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"Shift", " ", "in", " ", "y", " ", "direction"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"calculateIntensitiesLR", "[", 
        RowBox[{
         RowBox[{"EstimateMu", "[", 
          RowBox[{"10", ",", "5"}], "]"}], ",", 
         RowBox[{"EstimateSigma", "[", 
          RowBox[{"10", ",", "5"}], "]"}], ",", 
         RowBox[{"EstimateMu", "[", 
          RowBox[{"250", ",", "10"}], "]"}], ",", 
         RowBox[{"EstimateSigma", "[", 
          RowBox[{"250", ",", "10"}], "]"}]}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "100"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"calculateIntensitiesLR", "[", 
        RowBox[{
         RowBox[{"EstimateMu", "[", 
          RowBox[{"10", ",", "5"}], "]"}], ",", 
         RowBox[{"EstimateSigma", "[", 
          RowBox[{"10", ",", "5"}], "]"}], ",", 
         RowBox[{"EstimateMu", "[", 
          RowBox[{"250", ",", "100"}], "]"}], ",", 
         RowBox[{"EstimateSigma", "[", 
          RowBox[{"250", ",", "100"}], "]"}]}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1000"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"calculateIntensitiesLR", "[", 
        RowBox[{
         RowBox[{"EstimateMu", "[", 
          RowBox[{"10", ",", "10"}], "]"}], ",", 
         RowBox[{"EstimateSigma", "[", 
          RowBox[{"10", ",", "10"}], "]"}], ",", 
         RowBox[{"EstimateMu", "[", 
          RowBox[{"250", ",", "250"}], "]"}], ",", 
         RowBox[{"EstimateSigma", "[", 
          RowBox[{"250", ",", "250"}], "]"}]}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "50000"}], "}"}]}], "}"}]}]}], 
     RowBox[{"(*", 
      RowBox[{",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "1"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "1"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "250"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "250"}], "]"}]}], "]"}], ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "10000"}], "}"}]}], "}"}]}]}], "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"10", "^", 
          RowBox[{"-", "3"}]}], ",", " ", 
         RowBox[{"10", "^", "1"}]}], "}"}], ",", "Automatic"}], "}"}]}], ",", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{"{", " ", 
      RowBox[{
       RowBox[{"10", "^", 
        RowBox[{"-", "10"}]}], ",", 
       RowBox[{"10", "^", "4"}]}], "}"}], " ", "*)"}], "\[IndentingNewLine]", 
    
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks2", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
      " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
      "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"P\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"(\"\
,FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\)\!\(\*\
StyleBox[\")\",FontSlant->\"Italic\"]\)\>\"", ",", " ", "None"}], "}"}], ",", 
       
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.4", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.8", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
          "}"}]}], "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"PlotStyle", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "1", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "0.8", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "0.6", "]"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", " ", 
         RowBox[{"Opacity", "[", "0.4", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", " ", 
         RowBox[{"Opacity", "[", "0.2", "]"}]}], "}"}]}], "}"}]}], ",", " ", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Monodisperse\>\"", ",", " ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 1 & \
\!\(\*SubscriptBox[\"\[Sigma]\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = \
10\>\"", ",", " ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 5 & \
\!\(\*SubscriptBox[\"\[Sigma]\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = \
10\>\"", ",", "  ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 5 & \
\!\(\*SubscriptBox[\"\[Sigma]\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = \
100\>\"", ",", "  ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 10 & \!\(\*SubscriptBox[\"\[Sigma]\
\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = 250\>\""}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameStyle", "\[Rule]", 
     RowBox[{"{", "Black", "}"}]}]}], "\[IndentingNewLine]", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
      "\"\<FormFactors_R250_L10.pdf\>\""}], "}"}], "]"}], ",", 
   RowBox[{"Show", "[", 
    RowBox[{"plotFormFactors", ",", " ", 
     RowBox[{"ImageSize", " ", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"8", " ", "cm"}], ",", " ", 
        RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{
  3.9041859453120747`*^9, {3.9041859884525213`*^9, 3.9041860365389853`*^9}, 
   3.904186090409512*^9, {3.904186223611288*^9, 3.904186244710867*^9}, {
   3.9041862958932896`*^9, 3.904186311704144*^9}, {3.9041863552670774`*^9, 
   3.904186397181115*^9}, {3.9041864280776205`*^9, 3.90418643888125*^9}, {
   3.9041864696118755`*^9, 3.904186503017561*^9}, {3.904186533330944*^9, 
   3.9041865934307604`*^9}, {3.904187288923519*^9, 3.904187288978771*^9}, {
   3.9041902799460115`*^9, 3.9041903032587795`*^9}, {3.904190334439412*^9, 
   3.904190338534717*^9}, {3.9041903900473394`*^9, 3.9041905544580836`*^9}, {
   3.9041905916254983`*^9, 3.904190593152613*^9}, {3.904190655323888*^9, 
   3.904190724775958*^9}, {3.90419075487151*^9, 3.9041908138284054`*^9}, {
   3.9041908602529073`*^9, 3.9041910006364913`*^9}, {3.9041910894699326`*^9, 
   3.9041912701373653`*^9}, {3.904191311042491*^9, 3.9041913160712547`*^9}, {
   3.904191352623455*^9, 3.9041913772676783`*^9}, {3.9041914188590918`*^9, 
   3.9041914708604035`*^9}, {3.9041915049699335`*^9, 
   3.9041915118214664`*^9}, {3.904191701059563*^9, 3.904191728788476*^9}, 
   3.904191783947991*^9, {3.904191814782441*^9, 3.9041918162804976`*^9}, {
   3.9041918775355015`*^9, 3.9041919820739117`*^9}, {3.9041920575734663`*^9, 
   3.9041921529063153`*^9}, {3.9041923053514977`*^9, 
   3.9041923131257105`*^9}, {3.904193331301653*^9, 3.904193377447117*^9}, {
   3.9042047245983796`*^9, 3.904204741528363*^9}, 3.9042048871107216`*^9, {
   3.904205639912449*^9, 3.9042057093769984`*^9}, {3.9042057676239934`*^9, 
   3.9042058141770325`*^9}, {3.9042058488982134`*^9, 3.9042058785560975`*^9}, 
   3.904205931283575*^9, {3.904206014545142*^9, 3.9042060247203455`*^9}, {
   3.9042091641681604`*^9, 3.9042091674235477`*^9}, {3.904209209893922*^9, 
   3.9042092114429855`*^9}, {3.904209254270416*^9, 3.90420925726007*^9}, {
   3.904209514824728*^9, 3.904209514974721*^9}, 3.904642270070361*^9, {
   3.904643534636311*^9, 3.9046435350248237`*^9}, {3.9046435661971145`*^9, 
   3.9046435667569866`*^9}, 3.906016972018714*^9},
 CellLabel->
  "In[151]:=",ExpressionUUID->"ec4e3acb-9558-468a-9a3b-fca0ee179085"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"4302.21474091715`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 151, 39, 
   17050716133839058357, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.9041903476503673`*^9, 3.9041904017775154`*^9, 3.9041905027666492`*^9, 
   3.9041906018969316`*^9, {3.904190728878871*^9, 3.90419077680774*^9}, 
   3.904190815310687*^9, {3.904190866069703*^9, 3.9041908855758443`*^9}, {
   3.9041909306669903`*^9, 3.9041909684527044`*^9}, {3.904191112816313*^9, 
   3.9041911394359426`*^9}, 3.904191247938362*^9, 3.9041913251792145`*^9, 
   3.9041914794670067`*^9, 3.904191519304845*^9, 3.904191718500889*^9, 
   3.9041917681407013`*^9, 3.9041917995873785`*^9, 3.904191833759548*^9, 
   3.904191907747409*^9, 3.904192174589713*^9, 3.904193268278182*^9, {
   3.9041933575281096`*^9, 3.904193385425242*^9}, {3.9042047333251095`*^9, 
   3.9042047529909153`*^9}, 3.9042048972386117`*^9, 3.9042056815393963`*^9, 
   3.904205720803976*^9, 3.904205806703966*^9, 3.9042060338677483`*^9, 
   3.9042091771834946`*^9, 3.9042092234745193`*^9, 3.9042092673653674`*^9, 
   3.9042095240058827`*^9, 3.904643506284607*^9, 3.904643542944968*^9, 
   3.9046435742253056`*^9, 3.9060169805901084`*^9},
 CellLabel->
  "During evaluation of \
In[151]:=",ExpressionUUID->"84c847f3-ef5a-49d5-9f31-2fcf0a284903"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"4281.030879488564`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 151, 40, 
   17050716133839058357, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.9041903476503673`*^9, 3.9041904017775154`*^9, 3.9041905027666492`*^9, 
   3.9041906018969316`*^9, {3.904190728878871*^9, 3.90419077680774*^9}, 
   3.904190815310687*^9, {3.904190866069703*^9, 3.9041908855758443`*^9}, {
   3.9041909306669903`*^9, 3.9041909684527044`*^9}, {3.904191112816313*^9, 
   3.9041911394359426`*^9}, 3.904191247938362*^9, 3.9041913251792145`*^9, 
   3.9041914794670067`*^9, 3.904191519304845*^9, 3.904191718500889*^9, 
   3.9041917681407013`*^9, 3.9041917995873785`*^9, 3.904191833759548*^9, 
   3.904191907747409*^9, 3.904192174589713*^9, 3.904193268278182*^9, {
   3.9041933575281096`*^9, 3.904193385425242*^9}, {3.9042047333251095`*^9, 
   3.9042047529909153`*^9}, 3.9042048972386117`*^9, 3.9042056815393963`*^9, 
   3.904205720803976*^9, 3.904205806703966*^9, 3.9042060338677483`*^9, 
   3.9042091771834946`*^9, 3.9042092234745193`*^9, 3.9042092673653674`*^9, 
   3.9042095240058827`*^9, 3.904643506284607*^9, 3.904643542944968*^9, 
   3.9046435742253056`*^9, 3.906016980605204*^9},
 CellLabel->
  "During evaluation of \
In[151]:=",ExpressionUUID->"0744d2a3-4ef6-4470-a93a-62dcd4c59643"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"4260.060152605499`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 151, 41, 
   17050716133839058357, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.9041903476503673`*^9, 3.9041904017775154`*^9, 3.9041905027666492`*^9, 
   3.9041906018969316`*^9, {3.904190728878871*^9, 3.90419077680774*^9}, 
   3.904190815310687*^9, {3.904190866069703*^9, 3.9041908855758443`*^9}, {
   3.9041909306669903`*^9, 3.9041909684527044`*^9}, {3.904191112816313*^9, 
   3.9041911394359426`*^9}, 3.904191247938362*^9, 3.9041913251792145`*^9, 
   3.9041914794670067`*^9, 3.904191519304845*^9, 3.904191718500889*^9, 
   3.9041917681407013`*^9, 3.9041917995873785`*^9, 3.904191833759548*^9, 
   3.904191907747409*^9, 3.904192174589713*^9, 3.904193268278182*^9, {
   3.9041933575281096`*^9, 3.904193385425242*^9}, {3.9042047333251095`*^9, 
   3.9042047529909153`*^9}, 3.9042048972386117`*^9, 3.9042056815393963`*^9, 
   3.904205720803976*^9, 3.904205806703966*^9, 3.9042060338677483`*^9, 
   3.9042091771834946`*^9, 3.9042092234745193`*^9, 3.9042092673653674`*^9, 
   3.9042095240058827`*^9, 3.904643506284607*^9, 3.904643542944968*^9, 
   3.9046435742253056`*^9, 3.9060169806183205`*^9},
 CellLabel->
  "During evaluation of \
In[151]:=",ExpressionUUID->"231a1141-38a3-4e02-b032-62fe1fa4a012"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"General\\\", \
\\\"::\\\", \\\"munfl\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 151, 42, 17050716133839058357, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.9041903476503673`*^9, 3.9041904017775154`*^9, 3.9041905027666492`*^9, 
   3.9041906018969316`*^9, {3.904190728878871*^9, 3.90419077680774*^9}, 
   3.904190815310687*^9, {3.904190866069703*^9, 3.9041908855758443`*^9}, {
   3.9041909306669903`*^9, 3.9041909684527044`*^9}, {3.904191112816313*^9, 
   3.9041911394359426`*^9}, 3.904191247938362*^9, 3.9041913251792145`*^9, 
   3.9041914794670067`*^9, 3.904191519304845*^9, 3.904191718500889*^9, 
   3.9041917681407013`*^9, 3.9041917995873785`*^9, 3.904191833759548*^9, 
   3.904191907747409*^9, 3.904192174589713*^9, 3.904193268278182*^9, {
   3.9041933575281096`*^9, 3.904193385425242*^9}, {3.9042047333251095`*^9, 
   3.9042047529909153`*^9}, 3.9042048972386117`*^9, 3.9042056815393963`*^9, 
   3.904205720803976*^9, 3.904205806703966*^9, 3.9042060338677483`*^9, 
   3.9042091771834946`*^9, 3.9042092234745193`*^9, 3.9042092673653674`*^9, 
   3.9042095240058827`*^9, 3.904643506284607*^9, 3.904643542944968*^9, 
   3.9046435742253056`*^9, 3.906016980629567*^9},
 CellLabel->
  "During evaluation of \
In[151]:=",ExpressionUUID->"0d041726-e058-4a70-bf65-871002684cc9"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[1]], 
        LineBox[CompressedData["
1:eJw1lgk4VOsfx8fS2Blmn7GNQZay71f3uFFJKVeKf0QprcrWciOtFEolKgmF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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.8]], 
        LineBox[CompressedData["
1:eJw1lgdUU9kWhpOI9JpKElqAANKripRzFWdQYZSigw4qiAUUFKOyFBkBB3UY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         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.6]], 
        LineBox[CompressedData["
1:eJw1lgs4VOsax8f9OsysmTFmxm2GGaFE7S5C39dWm0ptUZEI7aLShXRBandR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         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.4]], 
        LineBox[CompressedData["
1:eJw1lgk4lWkbx49jy3JynP28r+0cS5aI4istnkeYLC3KiEZSqK+iVNMyyUhp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         "]]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.2]], 
        LineBox[CompressedData["
1:eJw1lglYjdkfx2/7euvW3e/tdve0jrFOEzrHEiKVUGiEhixFlszQWGqshRkz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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.907755278982122, -28.074152133337478`}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"P\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\
StyleBox[\\\"(\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\"q\\\",\
FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\")\\\",FontSlant->\\\"\
Italic\\\"]\\)\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> {
       GrayLevel[0]}, FrameTicks -> {{{{
          NCache[-Log[10000000000000], -29.933606208922594`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "13"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100000000000], -25.328436022934504`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "11"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000000000], -20.72326583694641], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "9"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10000000], -16.11809565095832], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "7"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           
           TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000000000000000000000000000000000], \
-299.33606208922595`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-
           Log[100000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000], \
-294.7308919032379], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000000000000000000000000000000000], \
-290.12572171724975`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000000000000000000000000000], \
-285.5205515312617], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000], \
-280.9153813452736], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000000000000000000000000000], -276.3102111592855], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000000000000000000000], -271.7050409732974], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000], -267.09987078730927`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000000000000000000000], -262.4947006013212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000000000000000], -257.8895304153331], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000], -253.28436022934503`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000000000000000], -248.67919004335693`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000000000], -244.07401985736885`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000], -239.46884967138075`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000000000], -234.86367948539265`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000], -230.25850929940458`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000], -225.65333911341648`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000], -221.04816892742838`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000], -216.4429987414403], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000], -211.8378285554522], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000], -207.2326583694641], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000], -202.62748818347603`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000], -198.02231799748793`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000], -193.41714781149983`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000], -188.81197762551176`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000], -184.20680743952366`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000], -179.60163725353556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000], -174.99646706754748`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000], -170.39129688155938`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000], -165.78612669557128`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000], -161.1809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000], -156.5757863235951], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0], -151.970616137607], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000000000000000000000000000]\
, -147.36544595161894`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000], \
-142.76027576563084`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-
           Log[1000000000000000000000000000000000000000000000000000000000000],\
 -138.15510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000000000000000000000], \
-133.54993539365464`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000], \
-128.94476520766656`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000000000000000000000], \
-124.33959502167846`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000000000000000], \
-119.73442483569038`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000], \
-115.12925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000000000000000], \
-110.52408446371419`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000000000], \
-105.9189142777261], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000], \
-101.31374409173802`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000000000], -96.70857390574992], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000], -92.10340371976183], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000], -87.49823353377374], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000], -82.89306334778564], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000], -78.28789316179756], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000000000000], -73.68272297580947], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000000000000000000000], -69.07755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000000000000000000], -64.47238260383328], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000000], -59.86721241784519], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000000000000000], -55.262042231857095`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000000000000], -50.65687204586901], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000], -46.051701859880914`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000000000], -41.44653167389282], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000000], -36.841361487904734`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000], -32.23619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000], -27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000], 18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000], 23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000], 27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000], 32.23619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000], 36.841361487904734`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000], 41.44653167389282], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000], 46.051701859880914`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000], 50.65687204586901], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000], 55.262042231857095`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000], 59.86721241784519], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000], 64.47238260383328], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000], 69.07755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000000000], 73.68272297580947], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000], 78.28789316179756], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000000000], 82.89306334778564], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000000000000000], 87.49823353377374], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000], 92.10340371976183], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000000000000000], 
           96.70857390574992], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000000000000000000000], 
           101.31374409173802`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000], 
           105.9189142777261], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000000000000000000000], 
           110.52408446371419`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000000000000000000000000000], 
           115.12925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000000000], 
           119.73442483569038`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000000000000000000000000000], 
           124.33959502167846`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000000000000000000000000000000000], 
           128.94476520766656`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000000000000000], 
           133.54993539365464`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000000000000000000000000000000000],
            138.15510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000], -29.933606208922594`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000000000], -29.240459028362647`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 3]], -28.834993920254483`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000000000], -28.547311847802703`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000000000], -28.324168296488494`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000000000, 3]], -28.14184673969454], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 7]], -27.98769605986728], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000000000], -27.85416466724276], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 9]], -27.736381631586376`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000000000], -27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000000000], -26.937873935368604`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 3]], -26.53240882726044], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000000000], -26.244726754808656`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000000000], -26.021583203494448`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000000000, 3]], -25.839261646700493`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 7]], -25.685110966873236`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000000000], -25.551579574248713`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 9]], -25.43379653859233], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000000000], -25.328436022934504`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000000], -24.635288842374557`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 3]], -24.229823734266393`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000000], -23.942141661814613`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000000], -23.7189981105004], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000000, 3]], -23.536676553706446`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 7]], -23.38252587387919], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000000], -23.248994481254666`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 9]], -23.131211445598282`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000000], -22.33270374938051], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 3]], -21.927238641272346`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000000], -21.639556568820566`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000000], -21.416413017506358`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000000, 3]], -21.234091460712403`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 7]], -21.079940780885142`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000000], -20.94640938826062], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 9]], -20.82862635260424], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000000], -20.72326583694641], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000000], -20.030118656386467`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 3]], -19.624653548278303`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000000], -19.33697147582652], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000000], -19.11382792451231], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000000, 3]], -18.931506367718356`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 7]], -18.7773556878911], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000000], -18.643824295266576`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 9]], -18.526041259610192`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000], -17.72753356339242], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 3]], -17.322068455284256`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000], -17.034386382832476`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000], -16.811242831518264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000, 3]], -16.62892127472431], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 7]], -16.474770594897052`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000], -16.34123920227253], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 9]], -16.223456166616145`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000], -16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000], -15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 3]], -15.01948336229021], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000], -14.73180128983843], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000], -14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000, 3]], -14.326336181730264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 7]], -14.172185501903007`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000], -14.038654109278484`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 9]], -13.9208710736221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000], -13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 3]], -12.716898269296165`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000], -12.429216196844383`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000], -12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000, 3]], -12.02375108873622], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 7]], -11.86960040890896], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000], -11.736069016284437`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 9]], -11.618285980628055`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000000], 14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000000], 14.914122846632385`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000000], 15.201804919084164`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000000], 15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000000], 15.60727002719233], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000000], 15.761420707019587`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000000], 15.89495209964411], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000000], 16.012735135300492`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[10000000000000], -29.933606208922594`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000], -27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000], -25.328436022934504`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000], -20.72326583694641], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000], -16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000], -29.933606208922594`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000000000], -29.240459028362647`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 3]], -28.834993920254483`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000000000], -28.547311847802703`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000000000], -28.324168296488494`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000000000, 3]], -28.14184673969454], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 7]], -27.98769605986728], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000000000], -27.85416466724276], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 9]], -27.736381631586376`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000000000], -27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000000000], -26.937873935368604`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 3]], -26.53240882726044], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000000000], -26.244726754808656`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000000000], -26.021583203494448`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000000000, 3]], -25.839261646700493`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 7]], -25.685110966873236`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000000000], -25.551579574248713`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 9]], -25.43379653859233], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000000000], -25.328436022934504`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000000], -24.635288842374557`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 3]], -24.229823734266393`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000000], -23.942141661814613`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000000], -23.7189981105004], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000000, 3]], -23.536676553706446`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 7]], -23.38252587387919], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000000], -23.248994481254666`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 9]], -23.131211445598282`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000000], -22.33270374938051], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 3]], -21.927238641272346`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000000], -21.639556568820566`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000000], -21.416413017506358`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000000, 3]], -21.234091460712403`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 7]], -21.079940780885142`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000000], -20.94640938826062], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 9]], -20.82862635260424], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000000], -20.72326583694641], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000000], -20.030118656386467`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 3]], -19.624653548278303`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000000], -19.33697147582652], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000000], -19.11382792451231], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000000, 3]], -18.931506367718356`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 7]], -18.7773556878911], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000000], -18.643824295266576`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 9]], -18.526041259610192`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000], -17.72753356339242], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 3]], -17.322068455284256`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000], -17.034386382832476`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000], -16.811242831518264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000, 3]], -16.62892127472431], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 7]], -16.474770594897052`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000], -16.34123920227253], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 9]], -16.223456166616145`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000], -16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000], -15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 3]], -15.01948336229021], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000], -14.73180128983843], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000], -14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000, 3]], -14.326336181730264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 7]], -14.172185501903007`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000], -14.038654109278484`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 9]], -13.9208710736221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000], -13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 3]], -12.716898269296165`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000], -12.429216196844383`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000], -12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000, 3]], -12.02375108873622], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 7]], -11.86960040890896], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000], -11.736069016284437`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 9]], -11.618285980628055`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000000], 14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000000], 14.914122846632385`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000000], 15.201804919084164`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000000], 15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000000], 15.60727002719233], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000000], 15.761420707019587`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000000], 15.89495209964411], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000000], 16.012735135300492`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 
      2.302585092994046}, {-28.074152133337478`, 10.354929242544431`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"Monodisperse\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 1 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 10\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 5 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 10\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 5 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 100\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 10 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 250\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[1]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.8]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.8]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #5}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.8`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.6`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.4`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.2`", "]"}]}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
               "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.904190763927281*^9, 3.904190784847489*^9}, 
   3.904190824216564*^9, {3.9041908750426626`*^9, 3.9041908951417494`*^9}, {
   3.90419093959441*^9, 3.9041909781694927`*^9}, {3.904191121526598*^9, 
   3.9041911485886297`*^9}, 3.9041912493882833`*^9, 3.9041913268265076`*^9, 
   3.9041914725880456`*^9, 3.9041915206280174`*^9, 3.9041917197907605`*^9, 
   3.9041917697979903`*^9, 3.9041918009237113`*^9, 3.904191835105816*^9, 
   3.9041919091400146`*^9, 3.904192175933033*^9, 3.9041932696302547`*^9, {
   3.9041933594928875`*^9, 3.9041933875926466`*^9}, {3.9042047353702946`*^9, 
   3.9042047557258425`*^9}, 3.9042048991217747`*^9, 3.9042056832623467`*^9, 
   3.904205723474777*^9, 3.904205808783654*^9, 3.9042060356711893`*^9, 
   3.904209179419348*^9, 3.9042092257431755`*^9, 3.904209269727947*^9, 
   3.904209525940782*^9, 3.9046435079749603`*^9, 3.9046435450459347`*^9, 
   3.904643576099083*^9, 3.9060169825663996`*^9},
 CellLabel->
  "Out[151]=",ExpressionUUID->"0582e022-fb0c-4aed-9a91-4607be8881ee"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Manuscript \
SAXS\\\\SAXS analysis\\\\FormFactors_R250_L10.pdf\"\>"], "Output",
 CellChangeTimes->{{3.904190763927281*^9, 3.904190784847489*^9}, 
   3.904190824216564*^9, {3.9041908750426626`*^9, 3.9041908951417494`*^9}, {
   3.90419093959441*^9, 3.9041909781694927`*^9}, {3.904191121526598*^9, 
   3.9041911485886297`*^9}, 3.9041912493882833`*^9, 3.9041913268265076`*^9, 
   3.9041914725880456`*^9, 3.9041915206280174`*^9, 3.9041917197907605`*^9, 
   3.9041917697979903`*^9, 3.9041918009237113`*^9, 3.904191835105816*^9, 
   3.9041919091400146`*^9, 3.904192175933033*^9, 3.9041932696302547`*^9, {
   3.9041933594928875`*^9, 3.9041933875926466`*^9}, {3.9042047353702946`*^9, 
   3.9042047557258425`*^9}, 3.9042048991217747`*^9, 3.9042056832623467`*^9, 
   3.904205723474777*^9, 3.904205808783654*^9, 3.9042060356711893`*^9, 
   3.904209179419348*^9, 3.9042092257431755`*^9, 3.904209269727947*^9, 
   3.904209525940782*^9, 3.9046435079749603`*^9, 3.9046435450459347`*^9, 
   3.904643576099083*^9, 3.9060169857897224`*^9},
 CellLabel->
  "Out[152]=",ExpressionUUID->"7c96391e-3cff-4030-b26c-8a9d2d7ecbbf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"plotSlopes", " ", "=", " ", 
  RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"slope", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"qlist", ",", 
          RowBox[{"P11", "[", 
           RowBox[{"qlist", ",", "250", ",", "10"}], "]"}]}], "}"}], 
        "\[Transpose]"}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "1"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "1"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "10"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "10"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"Shift", " ", "in", " ", "y", " ", "direction"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "10"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "10"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "100"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "100"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "10"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "10"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "250"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "250"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"10", "^", 
          RowBox[{"-", "3"}]}], ",", " ", 
         RowBox[{"10", "^", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5"}], ",", " ", "0"}], "}"}]}], "}"}]}], ",", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"{", " ", 
      RowBox[{
       RowBox[{"10", "^", 
        RowBox[{"-", "10"}]}], ",", 
       RowBox[{"10", "^", "4"}]}], "}"}], " ", "*)"}], "\[IndentingNewLine]", 
    
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
      " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
      "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.4", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.8", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
          "}"}]}], "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"PlotStyle", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "1", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "0.8", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "0.6", "]"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", " ", 
         RowBox[{"Opacity", "[", "0.4", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", " ", 
         RowBox[{"Opacity", "[", "0.2", "]"}]}], "}"}]}], "}"}]}], ",", " ", 
    "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Monodisperse\>\"", ",", " ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 1 & \
\!\(\*SubscriptBox[\"\[Sigma]\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = \
10\>\"", ",", " ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 5 & \
\!\(\*SubscriptBox[\"\[Sigma]\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = \
10\>\"", ",", "  ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 5 & \
\!\(\*SubscriptBox[\"\[Sigma]\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = \
100\>\"", ",", "  ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 10 & \!\(\*SubscriptBox[\"\[Sigma]\
\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = 250\>\""}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
      "\"\<FormFactorsSlopes_R250_L10.pdf\>\""}], "}"}], "]"}], ",", 
   RowBox[{"Show", "[", 
    RowBox[{"plotSlopes", ",", " ", 
     RowBox[{"ImageSize", " ", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"8", " ", "cm"}], ",", " ", 
        RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.904204148977622*^9, 3.9042042501767282`*^9}, {
   3.904204287251051*^9, 3.9042042881103563`*^9}, {3.904204324074394*^9, 
   3.904204353252767*^9}, 3.9042043944755707`*^9, {3.9042044389779544`*^9, 
   3.904204458576953*^9}, {3.9042045052605157`*^9, 3.904204571418418*^9}, {
   3.904204614961651*^9, 3.904204699388088*^9}, 3.9042048775437136`*^9, {
   3.9042053883657856`*^9, 3.904205388932059*^9}, {3.904205424667331*^9, 
   3.9042054255500813`*^9}, {3.904206103786495*^9, 3.904206109684391*^9}, {
   3.9042091183959017`*^9, 3.904209143173911*^9}, {3.9046435906976852`*^9, 
   3.9046435910249367`*^9}, 3.9060169815833635`*^9},
 CellLabel->
  "In[153]:=",ExpressionUUID->"8216ce0b-9b35-4c62-acff-591ffe4f31e6"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"4302.21474091715`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 153, 43, 
   17050716133839058357, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.9042045707613688`*^9, {3.904204632118705*^9, 3.904204658529045*^9}, 
   3.904204706912072*^9, 3.904204924392743*^9, 3.9042053966516733`*^9, 
   3.9042054347843237`*^9, 3.904206117766975*^9, 3.9042062160131454`*^9, {
   3.9042091266345916`*^9, 3.904209155263682*^9}, 3.906017000511748*^9},
 CellLabel->
  "During evaluation of \
In[153]:=",ExpressionUUID->"6dd4a22c-d86f-4777-8ada-a9e0f9680d28"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"4281.030879488564`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 153, 44, 
   17050716133839058357, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.9042045707613688`*^9, {3.904204632118705*^9, 3.904204658529045*^9}, 
   3.904204706912072*^9, 3.904204924392743*^9, 3.9042053966516733`*^9, 
   3.9042054347843237`*^9, 3.904206117766975*^9, 3.9042062160131454`*^9, {
   3.9042091266345916`*^9, 3.904209155263682*^9}, 3.9060170005514517`*^9},
 CellLabel->
  "During evaluation of \
In[153]:=",ExpressionUUID->"03078e89-90ca-4d94-8bfe-9a5e5c3560f4"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"4260.060152605499`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 153, 45, 
   17050716133839058357, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.9042045707613688`*^9, {3.904204632118705*^9, 3.904204658529045*^9}, 
   3.904204706912072*^9, 3.904204924392743*^9, 3.9042053966516733`*^9, 
   3.9042054347843237`*^9, 3.904206117766975*^9, 3.9042062160131454`*^9, {
   3.9042091266345916`*^9, 3.904209155263682*^9}, 3.9060170005741034`*^9},
 CellLabel->
  "During evaluation of \
In[153]:=",ExpressionUUID->"87ae58f2-050a-4e6f-92d3-c95dd249bef6"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"General\\\", \
\\\"::\\\", \\\"munfl\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 153, 46, 17050716133839058357, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.9042045707613688`*^9, {3.904204632118705*^9, 3.904204658529045*^9}, 
   3.904204706912072*^9, 3.904204924392743*^9, 3.9042053966516733`*^9, 
   3.9042054347843237`*^9, 3.904206117766975*^9, 3.9042062160131454`*^9, {
   3.9042091266345916`*^9, 3.904209155263682*^9}, 3.9060170005925384`*^9},
 CellLabel->
  "During evaluation of \
In[153]:=",ExpressionUUID->"234fef84-9de3-4105-8ef7-6760ea60a65e"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[1]], 
        LineBox[CompressedData["
1:eJwdknk8FAgfxucyjIZmzLjG8rIhq4PVSsqRFNG6ybmUaFWkUqHIkQ4RWzvK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         "]], 
        LineBox[{{-0.15897359698658403`, 
         0.}, {-0.11512925464970238`, -1.6287746525129954`}, \
{-0.0690775527898214, -3.47315360659058}, {-0.037921523974685165`, -5.}}], 
        LineBox[{{0.4181125955120058, 0.}, {
         0.43749116766886903`, -2.2035933738520566`}, {
         0.4592548101070294, -5.}}], 
        LineBox[{{1.0300566618934435`, 0.}, {
         1.0361632918473205`, -2.7912051877389294`}, {
         1.0405805788006257`, -5.}}], 
        LineBox[{{1.4030544629840807`, 0.}, {
         1.404576906726368, -2.0079076160471723`}, {1.406616190220153, -5.}}], 
        LineBox[{{-0.4630091954351677, -5.}, {-0.45558763115351936`, 0.}}], 
        LineBox[{{0.228351298675993, -5.}, {0.23165559146828285`, 0.}}], 
        LineBox[{{0.6388805057950484, -5.}, {0.6418271126351097, 0.}}], 
        LineBox[{{0.7712896436868366, 0.}, {0.7913156694506129, -5.}}], 
        LineBox[{{0.9206531506765594, -5.}, {0.922823593514723, 0.}}], 
        LineBox[{{1.148580701936892, -5.}, {1.1506253823231076`, 0.}}], 
        LineBox[{{1.232974324436615, 0.}, {1.2404666107865674`, -5.}}], 
        LineBox[{{1.3325406971710336`, -5.}, {1.3345793895516362`, 0.}}], 
        LineBox[{{1.4747166083386538`, -5.}, {1.476581691130728, 0.}}], 
        LineBox[{{1.5454662411386455`, 0.}, {1.5483748203367542`, -5.}}], 
        LineBox[{{1.6118059464218635`, -5.}, {1.6134630565154207`, 0.}}], 
        LineBox[{{1.6728481717421073`, 0.}, {1.675795498224752, -5.}}], 
        LineBox[{{1.7423368266672223`, -5.}, {1.7475824435325478`, 0.}}], 
        LineBox[{{1.784443588757234, 0.}, {1.786808128178082, -5.}}], 
        LineBox[{{1.8414204048096063`, -5.}, {1.8430619614124528`, 0.}}], 
        LineBox[{{1.8846481089094325`, 0.}, {1.8861050511640203`, -5.}}], 
        LineBox[{{1.933963364019762, -5.}, {1.9352909742520752`, 0.}}], 
        LineBox[{{1.9838264927609561`, 0.}, {1.985440323567661, -5.}}], 
        LineBox[{{2.026707434680225, -5.}, {2.02883324280162, 0.}}], 
        LineBox[{{2.084133064413623, 0.}, {2.0877508433225147`, -5.}}], 
        LineBox[{{2.1569101102114057`, -5.}, {2.1610871000057172`, 0.}}], 
        LineBox[{{2.2126654353104493`, 0.}, {2.2166588091265904`, -5.}}]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.8]], 
        LineBox[CompressedData["
1:eJwdlHk0FQgbxu/mcst+rVdpFDJkcCNJUSpFFEXkypamJJksMdZIJYohRMlY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         "]], 
        LineBox[{{-0.4688204575101751, -5.}, {-0.43749116766886864`, \
-0.6433454783941588}, {-0.4302860950680478, 0.}}], 
        LineBox[{{-0.17881385198727553`, 
         0.}, {-0.16118095650958336`, -0.5318205695472396}, \
{-0.11512925464970238`, -1.997376484309941}, {-0.0690775527898214, \
-3.522347385677641}, {-0.023801010352197574`, -5.}}], 
        LineBox[{{0.2283390833420773, -5.}, {
         0.25328436022934525`, -2.288930894389084}, {0.2824571281479475, 
         0.}}], 
        LineBox[{{0.3887900081780114, 0.}, {
         0.3914394658089881, -0.09955963574571475}, {
         0.43749116766886903`, -2.533395035390017}, {
         0.48354286952875003`, -4.975984501363636}, {
         0.48410533409074263`, -5.}}], 
        LineBox[{{0.6373097806113421, -5.}, {
         0.6677496769682738, -2.9495469027896704`}, {
         0.7138013788281548, -1.2910024509851072`}, {
         0.7598530806880354, -2.0056319128691804`}, {
         0.8059047825479155, -3.7902440255937084`}, {
         0.8480677395617213, -5.}}], 
        LineBox[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAAy+6k0VA57T8AAAAAAAAUwCIlHxW9
Ne4/IJ732G+gEcAlX0yA/q7vP0FBMzh2/ArAk8y89R+U8D899xhYdPgKwJRp
U6vAUPE/z56r3SQKEMCVBupgYQ3yP2caBUPG3xDAlqOAFgLK8j9HE07UbG0Q
wJhAF8yihvM/deM1ZnolEMCY3a2BQ0P0P1DaEZ5stw/AmnpEN+T/9D+eptGe
26wPwJoX2+yEvPU/FOzWdrSHEMCbtHGiJXn2P/lCYo/cHxDAnFEIWMY19z+G
LL6LpPgOwJ7ung1n8vc/QnsYa0rmD8CeizXDB6/4Pz7Br3eXSg/AoCjMeKhr
+T/1tdr7mlsPwKDFYi5JKPo/Ie9oz6d2EMCiYvnj6eT6P+ae+rFYjhDAov+P
mYqh+z8dgBJkfjYPwKScJk8rXvw/exWM5oshD8CkOb0EzBr9P3V2iOkLqBDA
ptZTumzX/T8yUzFpq5IQwKRz6m8NlP4/mK3ZMablD8CjEIElrlD/Pxpr73U1
ABDA0taLbacGAEAV8CJYTagPwFIlV8j3ZABAVnaFYhwOD8DUcyIjSMMAQCj0
mkD62g/AVMLtfZghAUAjW6oHPb4QwNQQudjofwFADnQwwxArEMBUX4QzOd4B
QFFuBPRy5A3A1q1Pjok8AkDK7v8Ak5QMwAcg8Ss=
         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.6]], 
        LineBox[CompressedData["
1:eJw1lnk8VN8bx8eMbSwzdwZjjKwlJGlBEd0p7Yus30ghtEiFVJYIJSn5ipKs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         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.4]], 
        LineBox[CompressedData["
1:eJw9lnk4VVsfx7fpGI+zj9kxT1GKN1EdxVbSaE4p3GRIRDe3cjMPdcrUcHMp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         "]]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.2]], 
        LineBox[CompressedData["
1:eJw1Vnk4VtsX/swzx8xHQmaigZDhKIp0KzIVRaSQjCWRIVIqISJDkpBbJJmi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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {-6.907755278982122, 0}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Slope\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> GrayLevel[0], 
     FrameTicks -> {{Automatic, Automatic}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 2.302585092994046}, {-5., 0.}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"Monodisperse\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 1 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 10\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 5 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 10\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 5 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 100\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 10 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 250\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[1]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.8]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.8]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #5}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.8`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.6`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.4`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.2`", "]"}]}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
               "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.9042042765227785`*^9, {3.904204338079912*^9, 3.904204357267268*^9}, {
   3.9042044406780567`*^9, 3.9042044544205294`*^9}, {3.904204554960986*^9, 
   3.9042045725501585`*^9}, {3.9042046337950153`*^9, 3.904204660172227*^9}, 
   3.904204708579156*^9, 3.9042049269127426`*^9, 3.904205398465316*^9, 
   3.904205436525323*^9, 3.904206119723288*^9, 3.904206218547572*^9, {
   3.904209128373577*^9, 3.904209156913768*^9}, 3.906017002944087*^9},
 CellLabel->
  "Out[153]=",ExpressionUUID->"86f5f03c-35a3-4c3f-90cd-2fab2b8f0497"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Manuscript \
SAXS\\\\SAXS analysis\\\\FormFactorsSlopes_R250_L10.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.9042042765227785`*^9, {3.904204338079912*^9, 3.904204357267268*^9}, {
   3.9042044406780567`*^9, 3.9042044544205294`*^9}, {3.904204554960986*^9, 
   3.9042045725501585`*^9}, {3.9042046337950153`*^9, 3.904204660172227*^9}, 
   3.904204708579156*^9, 3.9042049269127426`*^9, 3.904205398465316*^9, 
   3.904205436525323*^9, 3.904206119723288*^9, 3.904206218547572*^9, {
   3.904209128373577*^9, 3.904209156913768*^9}, 3.906017003942252*^9},
 CellLabel->
  "Out[154]=",ExpressionUUID->"9ae42558-f4a0-4ad4-934c-806171ce995b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"plotSlopes", " ", "=", " ", 
  RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"qlist", ",", 
           RowBox[{"P11", "[", 
            RowBox[{"qlist", ",", "250", ",", "10"}], "]"}]}], "}"}], 
         "\[Transpose]"}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"slope", "[", 
         RowBox[{"calculateIntensitiesLR", "[", 
          RowBox[{
           RowBox[{"EstimateMu", "[", 
            RowBox[{"10", ",", "1"}], "]"}], ",", 
           RowBox[{"EstimateSigma", "[", 
            RowBox[{"10", ",", "1"}], "]"}], ",", 
           RowBox[{"EstimateMu", "[", 
            RowBox[{"250", ",", "10"}], "]"}], ",", 
           RowBox[{"EstimateSigma", "[", 
            RowBox[{"250", ",", "10"}], "]"}]}], "]"}], "]"}], ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ","}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{"Shift", " ", "in", " ", "y", " ", "direction"}], "*)"}], 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "10"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "10"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "100"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "100"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "10"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "10"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "250"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "250"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"10", "^", 
          RowBox[{"-", "3"}]}], ",", " ", 
         RowBox[{"10", "^", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5"}], ",", " ", "0"}], "}"}]}], "}"}]}], ",", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"{", " ", 
      RowBox[{
       RowBox[{"10", "^", 
        RowBox[{"-", "10"}]}], ",", 
       RowBox[{"10", "^", "4"}]}], "}"}], " ", "*)"}], "\[IndentingNewLine]", 
    
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
      " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
      "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GrayLevel", "[", "0", "]"}], ",", " ", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}],
            "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GrayLevel", "[", "0.2", "]"}], ",", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}],
            "}"}], ","}], "*)"}], 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.4", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.8", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
          "}"}]}], "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"PlotStyle", "->", " ", 
     RowBox[{"{", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
          RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
          RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", 
          ",", " ", 
          RowBox[{"Opacity", "[", "1", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
          RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", 
          ",", " ", 
          RowBox[{"Opacity", "[", "0.8", "]"}]}], "}"}], ","}], "*)"}], 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "0.6", "]"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", " ", 
         RowBox[{"Opacity", "[", "0.4", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", " ", 
         RowBox[{"Opacity", "[", "0.2", "]"}]}], "}"}]}], "}"}]}], ",", " ", 
    "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"(*", 
       RowBox[{
       "\"\<Monodisperse\>\"", ",", " ", 
        "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 1 & \
\!\(\*SubscriptBox[\"\[Sigma]\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = \
10\>\"", ","}], "*)"}], " ", 
      RowBox[{
      "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 5 & \
\!\(\*SubscriptBox[\"\[Sigma]\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = \
10\>\"", ",", "  ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 5 & \
\!\(\*SubscriptBox[\"\[Sigma]\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = \
100\>\"", ",", "  ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 10 & \!\(\*SubscriptBox[\"\[Sigma]\
\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = 250\>\""}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
      "\"\<FormFactorsSlopesNoMonodisperse_R250_L10.pdf\>\""}], "}"}], "]"}], 
   ",", 
   RowBox[{"Show", "[", 
    RowBox[{"plotSlopes", ",", " ", 
     RowBox[{"ImageSize", " ", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"8", " ", "cm"}], ",", " ", 
        RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.904204839229111*^9, 3.9042048718722496`*^9}, {
   3.9042049317555485`*^9, 3.9042049883412623`*^9}, {3.9042050223158765`*^9, 
   3.904205080349517*^9}, {3.9042051298813424`*^9, 3.904205174798168*^9}, {
   3.904205274932716*^9, 3.9042053033232155`*^9}, {3.9042054692436066`*^9, 
   3.9042054695217905`*^9}, {3.9042055522564316`*^9, 
   3.9042055718789825`*^9}, {3.9042061569493556`*^9, 
   3.9042062015067644`*^9}, {3.90420640230344*^9, 3.9042064182799397`*^9}, {
   3.904206461454507*^9, 3.904206473675023*^9}, {3.904206530698953*^9, 
   3.904206546255148*^9}, {3.9042072473100376`*^9, 3.904207247690773*^9}, {
   3.9042074308287063`*^9, 3.904207442761796*^9}, {3.904207475401701*^9, 
   3.9042075090014286`*^9}, {3.90420795653526*^9, 3.904207986680415*^9}, {
   3.9042083571489944`*^9, 3.904208379672203*^9}, {3.904208416223054*^9, 
   3.9042084203195643`*^9}, {3.9042084696313033`*^9, 
   3.9042084864216757`*^9}, {3.9042085730513496`*^9, 3.904208577480511*^9}, {
   3.9042089296643457`*^9, 3.9042089462979665`*^9}, 3.9042090349367676`*^9, 
   3.904209285685599*^9, {3.9042095361642733`*^9, 3.9042095388575706`*^9}, {
   3.9046435971750565`*^9, 3.904643597446463*^9}, 3.9060170095432224`*^9},
 CellLabel->
  "In[155]:=",ExpressionUUID->"2c21e791-3c64-4814-add9-6f399d089f54"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"3284.088728164614`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 155, 47, 
   17050716133839058357, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.904204948875148*^9, 3.9042049761971817`*^9}, {
   3.904205024816019*^9, 3.904205082070112*^9}, {3.9042051381103387`*^9, 
   3.9042051465935926`*^9}, 3.90420517678071*^9, {3.904205290640106*^9, 
   3.904205314180396*^9}, 3.90420547746351*^9, 3.9042055753493023`*^9, 
   3.9042061923525352`*^9, 3.904206222855231*^9, 3.904206547917865*^9, {
   3.9042074857429714`*^9, 3.904207537810108*^9}, 3.9042079876603208`*^9, {
   3.904208359808215*^9, 3.9042083801701365`*^9}, 3.904208424429943*^9, {
   3.904208558671516*^9, 3.904208584082403*^9}, {3.904208758686345*^9, 
   3.9042087876121445`*^9}, 3.90420882358247*^9, {3.9042089420240088`*^9, 
   3.904208946834929*^9}, 3.9042090366878414`*^9, 3.9042092880978737`*^9, 
   3.9042095394408436`*^9, 3.9060170114977565`*^9},
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"7e64e8cd-a174-4245-8e16-0071a80ab897"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"3283.1661047079383`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 155, 48, 
   17050716133839058357, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.904204948875148*^9, 3.9042049761971817`*^9}, {
   3.904205024816019*^9, 3.904205082070112*^9}, {3.9042051381103387`*^9, 
   3.9042051465935926`*^9}, 3.90420517678071*^9, {3.904205290640106*^9, 
   3.904205314180396*^9}, 3.90420547746351*^9, 3.9042055753493023`*^9, 
   3.9042061923525352`*^9, 3.904206222855231*^9, 3.904206547917865*^9, {
   3.9042074857429714`*^9, 3.904207537810108*^9}, 3.9042079876603208`*^9, {
   3.904208359808215*^9, 3.9042083801701365`*^9}, 3.904208424429943*^9, {
   3.904208558671516*^9, 3.904208584082403*^9}, {3.904208758686345*^9, 
   3.9042087876121445`*^9}, 3.90420882358247*^9, {3.9042089420240088`*^9, 
   3.904208946834929*^9}, 3.9042090366878414`*^9, 3.9042092880978737`*^9, 
   3.9042095394408436`*^9, 3.906017011514954*^9},
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"de215fe0-fead-4f86-993f-70a6d0b55cd0"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"3282.252985264404`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 155, 49, 
   17050716133839058357, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.904204948875148*^9, 3.9042049761971817`*^9}, {
   3.904205024816019*^9, 3.904205082070112*^9}, {3.9042051381103387`*^9, 
   3.9042051465935926`*^9}, 3.90420517678071*^9, {3.904205290640106*^9, 
   3.904205314180396*^9}, 3.90420547746351*^9, 3.9042055753493023`*^9, 
   3.9042061923525352`*^9, 3.904206222855231*^9, 3.904206547917865*^9, {
   3.9042074857429714`*^9, 3.904207537810108*^9}, 3.9042079876603208`*^9, {
   3.904208359808215*^9, 3.9042083801701365`*^9}, 3.904208424429943*^9, {
   3.904208558671516*^9, 3.904208584082403*^9}, {3.904208758686345*^9, 
   3.9042087876121445`*^9}, 3.90420882358247*^9, {3.9042089420240088`*^9, 
   3.904208946834929*^9}, 3.9042090366878414`*^9, 3.9042092880978737`*^9, 
   3.9042095394408436`*^9, 3.9060170115278697`*^9},
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"49bc5ca1-21cd-46e7-a887-865ec193c4a4"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"General\\\", \
\\\"::\\\", \\\"munfl\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 155, 50, 17050716133839058357, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.904204948875148*^9, 3.9042049761971817`*^9}, {
   3.904205024816019*^9, 3.904205082070112*^9}, {3.9042051381103387`*^9, 
   3.9042051465935926`*^9}, 3.90420517678071*^9, {3.904205290640106*^9, 
   3.904205314180396*^9}, 3.90420547746351*^9, 3.9042055753493023`*^9, 
   3.9042061923525352`*^9, 3.904206222855231*^9, 3.904206547917865*^9, {
   3.9042074857429714`*^9, 3.904207537810108*^9}, 3.9042079876603208`*^9, {
   3.904208359808215*^9, 3.9042083801701365`*^9}, 3.904208424429943*^9, {
   3.904208558671516*^9, 3.904208584082403*^9}, {3.904208758686345*^9, 
   3.9042087876121445`*^9}, 3.90420882358247*^9, {3.9042089420240088`*^9, 
   3.904208946834929*^9}, 3.9042090366878414`*^9, 3.9042092880978737`*^9, 
   3.9042095394408436`*^9, 3.9060170115393243`*^9},
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"84702001-d624-4e00-8acf-c3b81607b81c"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.6]], 
        LineBox[CompressedData["
1:eJw1lnk8VN8bx8eMbSwzdwZjjKwlJGlBEd0p7Yus30ghtEiFVJYIJSn5ipKs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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.4]], 
        LineBox[CompressedData["
1:eJw9lnk4VVsfx7fpGI+zj9kxT1GKN1EdxVbSaE4p3GRIRDe3cjMPdcrUcHMp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         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.2]], 
        LineBox[CompressedData["
1:eJw1Vnk4VtsX/swzx8xHQmaigZDhKIp0KzIVRaSQjCWRIVIqISJDkpBbJJmi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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {-6.907755278982122, 0}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Slope\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> GrayLevel[0], 
     FrameTicks -> {{Automatic, Automatic}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 2.302585092994046}, {-5., 0.}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 5 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 10\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 5 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 100\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 10 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 250\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.6`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.4`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.2`", "]"}]}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.9042049510971394`*^9, 3.9042049787009907`*^9}, {
   3.90420502689854*^9, 3.904205083630991*^9}, {3.9042051388952513`*^9, 
   3.9042051470596333`*^9}, 3.904205177660756*^9, {3.9042052923319883`*^9, 
   3.904205316284109*^9}, 3.9042054791436996`*^9, 3.9042055765585775`*^9, 
   3.9042061940845275`*^9, 3.904206224603367*^9, 3.9042065490862694`*^9, {
   3.9042074869480314`*^9, 3.9042075389999943`*^9}, 3.904207988879837*^9, {
   3.904208360994763*^9, 3.9042083813900704`*^9}, 3.9042084256362476`*^9, {
   3.9042085598427496`*^9, 3.904208585341796*^9}, {3.9042087598523483`*^9, 
   3.9042087888141003`*^9}, 3.9042088247414417`*^9, {3.9042089431831074`*^9, 
   3.9042089483388777`*^9}, 3.9042090378395414`*^9, 3.9042092892899113`*^9, 
   3.9042095406908007`*^9, 3.9060170129494524`*^9},
 CellLabel->
  "Out[155]=",ExpressionUUID->"098edf49-7782-45e1-ab69-c207454cdcd6"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Manuscript \
SAXS\\\\SAXS analysis\\\\FormFactorsSlopesNoMonodisperse_R250_L10.pdf\"\>"], \
"Output",
 CellChangeTimes->{{3.9042049510971394`*^9, 3.9042049787009907`*^9}, {
   3.90420502689854*^9, 3.904205083630991*^9}, {3.9042051388952513`*^9, 
   3.9042051470596333`*^9}, 3.904205177660756*^9, {3.9042052923319883`*^9, 
   3.904205316284109*^9}, 3.9042054791436996`*^9, 3.9042055765585775`*^9, 
   3.9042061940845275`*^9, 3.904206224603367*^9, 3.9042065490862694`*^9, {
   3.9042074869480314`*^9, 3.9042075389999943`*^9}, 3.904207988879837*^9, {
   3.904208360994763*^9, 3.9042083813900704`*^9}, 3.9042084256362476`*^9, {
   3.9042085598427496`*^9, 3.904208585341796*^9}, {3.9042087598523483`*^9, 
   3.9042087888141003`*^9}, 3.9042088247414417`*^9, {3.9042089431831074`*^9, 
   3.9042089483388777`*^9}, 3.9042090378395414`*^9, 3.9042092892899113`*^9, 
   3.9042095406908007`*^9, 3.906017013918292*^9},
 CellLabel->
  "Out[156]=",ExpressionUUID->"acd74732-fdd1-4624-a916-eb67a37bb074"]
}, Open  ]],

Cell[BoxData[""], "Input",ExpressionUUID->"c4e43655-6657-478b-8231-bb4b9cd4e699"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"plotFormFactors", " ", "=", " ", 
  RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{
        RowBox[{"EstimateMu", "[", 
         RowBox[{"10", ",", "10"}], "]"}], ",", 
        RowBox[{"EstimateSigma", "[", 
         RowBox[{"10", ",", "10"}], "]"}], ",", 
        RowBox[{"EstimateMu", "[", 
         RowBox[{"250", ",", "250"}], "]"}], ",", 
        RowBox[{"EstimateSigma", "[", 
         RowBox[{"250", ",", "250"}], "]"}]}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1000"}], "}"}]}], "}"}]}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"10", "^", 
          RowBox[{"-", "3"}]}], ",", " ", 
         RowBox[{"10", "^", "0"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"10", "^", 
          RowBox[{"-", "5"}]}], ",", " ", 
         RowBox[{"10", "^", "3"}]}], "}"}]}], "}"}]}], ",", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"{", " ", 
      RowBox[{
       RowBox[{"10", "^", 
        RowBox[{"-", "10"}]}], ",", 
       RowBox[{"10", "^", "4"}]}], "}"}], " ", "*)"}], "\[IndentingNewLine]", 
    
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks2", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
      " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
      "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"P\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"(\"\
,FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\)\!\(\*\
StyleBox[\")\",FontSlant->\"Italic\"]\)\>\"", ",", " ", "None"}], "}"}], ",", 
       
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotStyle", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.2", "]"}], ",", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.4", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
        "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.8", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
        "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "18"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Monodisperse\>\"", ",", " ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 5 & \
\!\(\*SubscriptBox[\"\[Sigma]\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = \
10\>\"", ",", "  ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 10 & \!\(\*SubscriptBox[\"\[Sigma]\
\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = 100\>\"", ",", "  ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 10 & \!\(\*SubscriptBox[\"\[Sigma]\
\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = 250\>\""}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.904192323167556*^9, 3.904192323872614*^9}, {
  3.904192356718018*^9, 3.9041923739657946`*^9}},
 CellLabel->
  "In[862]:=",ExpressionUUID->"d2070e18-38e2-41d7-8cd1-b77426b7a375"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         GrayLevel[0], 
         PointSize[0.01], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJw1Vgk4VWkfv7Yrcq+7r9zr4srNxJOiVeeNUkmIDIW0oGZIaVffDCZTtH72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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.907755278982122, -11.512925464970204`}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"P\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\
StyleBox[\\\"(\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\"q\\\",\
FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\")\\\",FontSlant->\\\"\
Italic\\\"]\\)\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> GrayLevel[0], FrameTicks -> {{{{
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000], \
-115.12925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000000000000000], \
-110.52408446371419`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000000000], \
-105.9189142777261], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000], \
-101.31374409173802`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000000000], -96.70857390574992], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000], -92.10340371976183], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000], -87.49823353377374], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000], -82.89306334778564], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000], -78.28789316179756], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000000000000], -73.68272297580947], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000000000000000000000], -69.07755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000000000000000000], -64.47238260383328], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000000], -59.86721241784519], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000000000000000], -55.262042231857095`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000000000000], -50.65687204586901], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000], -46.051701859880914`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000000000], -41.44653167389282], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000000], -36.841361487904734`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000], -32.23619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000], -27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000], 18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000], 23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000], 27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000], 32.23619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000], 36.841361487904734`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000], 41.44653167389282], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000], 46.051701859880914`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000], 50.65687204586901], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000], 55.262042231857095`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000], 59.86721241784519], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000], 64.47238260383328], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000], 69.07755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 0.}, {-11.512925464970229`, 
      6.907755278982137}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"Monodisperse\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 5 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 10\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 10 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 100\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 10 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 250\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    PointSize[0.5], 
                    Thickness[0.09]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"], ",", 
                 RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                 RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}], "}"}], 
           ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"{", 
                 RowBox[{"False", ",", "Automatic"}], "}"}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", "True", "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.9041923275294476`*^9, {3.904192358089244*^9, 3.904192374971711*^9}, 
   3.9041932558611293`*^9},
 CellLabel->
  "Out[862]=",ExpressionUUID->"40d53cdf-d442-4362-a8f6-e4ceddb4292e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Plot", " ", "form", " ", "factors", " ", "for", " ", "platelets", " ", 
    "of", " ", "varying", " ", "dimensions", " ", "and", " ", "fixed", " ", 
    "polydispersity"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"plotFormFactors", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"qlist", ",", 
            RowBox[{"P11", "[", 
             RowBox[{"qlist", ",", "100", ",", "1"}], "]"}]}], "}"}], 
          "\[Transpose]"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"qlist", ",", 
            RowBox[{"P11", "[", 
             RowBox[{"qlist", ",", "100", ",", "10"}], "]"}]}], "}"}], 
          "\[Transpose]"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"qlist", ",", 
            RowBox[{"P11", "[", 
             RowBox[{"qlist", ",", "250", ",", "1"}], "]"}]}], "}"}], 
          "\[Transpose]"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "400"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"qlist", ",", 
            RowBox[{"P11", "[", 
             RowBox[{"qlist", ",", "250", ",", "10"}], "]"}]}], "}"}], 
          "\[Transpose]"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "2000"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"qlist", ",", 
            RowBox[{"P11", "[", 
             RowBox[{"qlist", ",", "500", ",", "10"}], "]"}]}], "}"}], 
          "\[Transpose]"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "50000"}], "}"}]}], "}"}]}]}], 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
          RowBox[{"calculateIntensitiesLR", "[", 
           RowBox[{
            RowBox[{"EstimateMu", "[", 
             RowBox[{"10", ",", "1"}], "]"}], ",", 
            RowBox[{"EstimateSigma", "[", 
             RowBox[{"10", ",", "1"}], "]"}], ",", 
            RowBox[{"EstimateMu", "[", 
             RowBox[{"250", ",", "10"}], "]"}], ",", 
            RowBox[{"EstimateSigma", "[", 
             RowBox[{"250", ",", "10"}], "]"}]}], "]"}], ".", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", " ", 
         RowBox[{"(*", " ", 
          RowBox[{"Shift", " ", "in", " ", "y", " ", "direction"}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"calculateIntensitiesLR", "[", 
           RowBox[{
            RowBox[{"EstimateMu", "[", 
             RowBox[{"10", ",", "5"}], "]"}], ",", 
            RowBox[{"EstimateSigma", "[", 
             RowBox[{"10", ",", "5"}], "]"}], ",", 
            RowBox[{"EstimateMu", "[", 
             RowBox[{"250", ",", "10"}], "]"}], ",", 
            RowBox[{"EstimateSigma", "[", 
             RowBox[{"250", ",", "10"}], "]"}]}], "]"}], ".", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "100"}], "}"}]}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"calculateIntensitiesLR", "[", 
           RowBox[{
            RowBox[{"EstimateMu", "[", 
             RowBox[{"10", ",", "5"}], "]"}], ",", 
            RowBox[{"EstimateSigma", "[", 
             RowBox[{"10", ",", "5"}], "]"}], ",", 
            RowBox[{"EstimateMu", "[", 
             RowBox[{"250", ",", "100"}], "]"}], ",", 
            RowBox[{"EstimateSigma", "[", 
             RowBox[{"250", ",", "100"}], "]"}]}], "]"}], ".", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1000"}], "}"}]}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"calculateIntensitiesLR", "[", 
           RowBox[{
            RowBox[{"EstimateMu", "[", 
             RowBox[{"10", ",", "10"}], "]"}], ",", 
            RowBox[{"EstimateSigma", "[", 
             RowBox[{"10", ",", "10"}], "]"}], ",", 
            RowBox[{"EstimateMu", "[", 
             RowBox[{"250", ",", "250"}], "]"}], ",", 
            RowBox[{"EstimateSigma", "[", 
             RowBox[{"250", ",", "250"}], "]"}]}], "]"}], ".", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "50000"}], "}"}]}], "}"}]}]}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"calculateIntensitiesLR", "[", 
           RowBox[{
            RowBox[{"EstimateMu", "[", 
             RowBox[{"10", ",", "1"}], "]"}], ",", 
            RowBox[{"EstimateSigma", "[", 
             RowBox[{"10", ",", "1"}], "]"}], ",", 
            RowBox[{"EstimateMu", "[", 
             RowBox[{"250", ",", "250"}], "]"}], ",", 
            RowBox[{"EstimateSigma", "[", 
             RowBox[{"250", ",", "250"}], "]"}]}], "]"}], ".", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "10000"}], "}"}]}], "}"}]}]}], "*)"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "3"}]}], ",", " ", 
           RowBox[{"10", "^", "1"}]}], "}"}], ",", "Automatic"}], "}"}]}], 
      ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"{", " ", 
        RowBox[{
         RowBox[{"10", "^", 
          RowBox[{"-", "10"}]}], ",", 
         RowBox[{"10", "^", "4"}]}], "}"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks2", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"P\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"(\
\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\)\!\(\*\
StyleBox[\")\",FontSlant->\"Italic\"]\)\>\"", ",", " ", "None"}], "}"}], ",", 
         
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"PlotStyle", "->", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"GrayLevel", "[", "0", "]"}], ",", " ", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", 
             "Automatic"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"GrayLevel", "[", "0.2", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
             RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", 
             "Automatic"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"GrayLevel", "[", "0.4", "]"}], ",", " ", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", 
             "Automatic"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", " ", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"GrayLevel", "[", "0.8", "]"}], ",", " ", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
            "}"}]}], "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", 
           ",", " ", 
           RowBox[{"Opacity", "[", "1", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", 
           ",", " ", 
           RowBox[{"Opacity", "[", "0.8", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", 
           ",", " ", 
           RowBox[{"Opacity", "[", "0.6", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", 
           " ", 
           RowBox[{"Opacity", "[", "0.4", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", 
           " ", 
           RowBox[{"Opacity", "[", "0.2", "]"}]}], "}"}]}], "}"}]}], ",", " ",
       "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 1 nm, \
\!\(\*StyleBox[\"R\",FontSlant->\"Italic\"]\) = 100 nm\>\"", ",", " ", 
         "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 10 nm, \
\!\(\*StyleBox[\"R\",FontSlant->\"Italic\"]\) = 100 nm\>\"", ",", " ", 
         "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 1 nm, \
\!\(\*StyleBox[\"R\",FontSlant->\"Italic\"]\) = 250 nm\>\"", ",", "  ", 
         "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 10 nm, \
\!\(\*StyleBox[\"R\",FontSlant->\"Italic\"]\) = 250 nm\>\"", ",", "  ", 
         "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 10 nm, \
\!\(\*StyleBox[\"R\",FontSlant->\"Italic\"]\) = 500 nm\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", 
       RowBox[{"{", "Black", "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<FormFactors_Monodisperse_Dimensions.pdf\>\""}], "}"}], "]"}], 
     ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotFormFactors", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.9071451998238287`*^9, 3.9071452218936872`*^9}, {
   3.9071452551883564`*^9, 3.907145327526991*^9}, 3.9071453722031226`*^9, {
   3.9071454918743134`*^9, 3.9071455450343275`*^9}, {3.90714639775727*^9, 
   3.9071464139416103`*^9}, {3.9071466349379673`*^9, 3.9071466425181985`*^9}},
 
 CellLabel->"In[84]:=",ExpressionUUID->"0e7a69cc-0930-409f-9504-ded371638160"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[1]], 
        LineBox[CompressedData["
1:eJw1lgk4VHsfx8e+RI0xwyyWmWGMRCSKFmdKi6TlKnGvhJK6UVquLFF5i0qL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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.8]], 
        LineBox[CompressedData["
1:eJw1lglYjWkbx895O9pPnZbT2dpOmxZaJGToeYgipShKUSENQzOSBmMrpcxn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         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.6]], 
        LineBox[CompressedData["
1:eJw1lgk4lGsbxyfGbhizvbMw9iUcLVRfKs8TX6X1OKWEUjmO9k7L1a69pI0S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         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.4]], 
        LineBox[CompressedData["
1:eJw9lgk4Vfkbx68r18519/VYr1Bh2mZa+P2iKSpFKgalGi0TKlpp/iOVJhXt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         "]]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.2]], 
        LineBox[CompressedData["
1:eJw1lglYTG0bx6dFaZmaafaZZprtpEnySnb1PC9eUWRLZUkksmQJhTdU1gpl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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.907755278982122, -23.62998910330235}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"P\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\
StyleBox[\\\"(\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\"q\\\",\
FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\")\\\",FontSlant->\\\"\
Italic\\\"]\\)\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> {
       GrayLevel[0]}, FrameTicks -> {{{{
          NCache[-Log[100000000000], -25.328436022934504`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "11"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000000000], -20.72326583694641], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "9"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10000000], -16.11809565095832], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "7"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           
           TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000], -253.28436022934503`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000000000000000], -248.67919004335693`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-
           Log[100000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000000000000], -244.07401985736885`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000], -239.46884967138075`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000000000], -234.86367948539265`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000], -230.25850929940458`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000], -225.65333911341648`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000], -221.04816892742838`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000], -216.4429987414403], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000], -211.8378285554522], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000], -207.2326583694641], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000], -202.62748818347603`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000], -198.02231799748793`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000], -193.41714781149983`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000], -188.81197762551176`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000], -184.20680743952366`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000], -179.60163725353556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000], -174.99646706754748`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000], -170.39129688155938`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000], -165.78612669557128`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000], -161.1809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000], -156.5757863235951], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0], -151.970616137607], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000000000000000000000000000]\
, -147.36544595161894`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000], \
-142.76027576563084`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000000000000000000000000000], \
-138.15510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000000000000000000000], \
-133.54993539365464`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000], \
-128.94476520766656`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000000000000000000000], \
-124.33959502167846`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000000000000000], \
-119.73442483569038`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000], \
-115.12925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000000000000000], \
-110.52408446371419`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000000000], \
-105.9189142777261], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000], \
-101.31374409173802`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000000000], -96.70857390574992], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000], -92.10340371976183], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000], -87.49823353377374], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000], -82.89306334778564], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000], -78.28789316179756], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000000000000], -73.68272297580947], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000000000000000000000], -69.07755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000000000000000000], -64.47238260383328], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000000], -59.86721241784519], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000000000000000], -55.262042231857095`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000000000000], -50.65687204586901], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000], -46.051701859880914`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000000000], -41.44653167389282], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000000], -36.841361487904734`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000], -32.23619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000], -27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000], 18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000], 23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000], 27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000], 32.23619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000], 36.841361487904734`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000], 41.44653167389282], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000], 46.051701859880914`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000], 50.65687204586901], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000], 55.262042231857095`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000], 59.86721241784519], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000], 64.47238260383328], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000], 69.07755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000000000], 73.68272297580947], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000], 78.28789316179756], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000000000], 82.89306334778564], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000000000000000], 87.49823353377374], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000], 92.10340371976183], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000000000000000], 
           96.70857390574992], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000000000000000000000], 
           101.31374409173802`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000], 
           105.9189142777261], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000000000000000000000], 
           110.52408446371419`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000000000000000000000000000], 
           115.12925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000000000], 
           119.73442483569038`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000000000000000000000000000], 
           124.33959502167846`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000000000000000000000000000000000], 
           128.94476520766656`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000000000000000], 
           133.54993539365464`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000000000000000000000000000000000],
            138.15510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000], -25.328436022934504`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000000], -24.635288842374557`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 3]], -24.229823734266393`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000000], -23.942141661814613`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000000], -23.7189981105004], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000000, 3]], -23.536676553706446`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 7]], -23.38252587387919], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000000], -23.248994481254666`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 9]], -23.131211445598282`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000000], -22.33270374938051], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 3]], -21.927238641272346`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000000], -21.639556568820566`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000000], -21.416413017506358`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000000, 3]], -21.234091460712403`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 7]], -21.079940780885142`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000000], -20.94640938826062], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 9]], -20.82862635260424], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000000], -20.72326583694641], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000000], -20.030118656386467`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 3]], -19.624653548278303`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000000], -19.33697147582652], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000000], -19.11382792451231], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000000, 3]], -18.931506367718356`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 7]], -18.7773556878911], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000000], -18.643824295266576`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 9]], -18.526041259610192`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000], -17.72753356339242], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 3]], -17.322068455284256`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000], -17.034386382832476`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000], -16.811242831518264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000, 3]], -16.62892127472431], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 7]], -16.474770594897052`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000], -16.34123920227253], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 9]], -16.223456166616145`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000], -16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000], -15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 3]], -15.01948336229021], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000], -14.73180128983843], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000], -14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000, 3]], -14.326336181730264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 7]], -14.172185501903007`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000], -14.038654109278484`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 9]], -13.9208710736221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000], -13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 3]], -12.716898269296165`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000], -12.429216196844383`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000], -12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000, 3]], -12.02375108873622], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 7]], -11.86960040890896], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000], -11.736069016284437`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 9]], -11.618285980628055`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000000], 14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000000], 14.914122846632385`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000000], 15.201804919084164`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000000], 15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000000], 15.60727002719233], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000000], 15.761420707019587`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000000], 15.89495209964411], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000000], 16.012735135300492`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[100000000000], -25.328436022934504`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000], -20.72326583694641], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000], -16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000], -25.328436022934504`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000000], -24.635288842374557`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 3]], -24.229823734266393`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000000], -23.942141661814613`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000000], -23.7189981105004], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000000, 3]], -23.536676553706446`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 7]], -23.38252587387919], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000000], -23.248994481254666`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 9]], -23.131211445598282`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000000], -22.33270374938051], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 3]], -21.927238641272346`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000000], -21.639556568820566`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000000], -21.416413017506358`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000000, 3]], -21.234091460712403`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 7]], -21.079940780885142`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000000], -20.94640938826062], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 9]], -20.82862635260424], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000000], -20.72326583694641], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000000], -20.030118656386467`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 3]], -19.624653548278303`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000000], -19.33697147582652], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000000], -19.11382792451231], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000000, 3]], -18.931506367718356`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 7]], -18.7773556878911], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000000], -18.643824295266576`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 9]], -18.526041259610192`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000], -17.72753356339242], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 3]], -17.322068455284256`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000], -17.034386382832476`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000], -16.811242831518264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000, 3]], -16.62892127472431], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 7]], -16.474770594897052`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000], -16.34123920227253], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 9]], -16.223456166616145`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000], -16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000], -15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 3]], -15.01948336229021], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000], -14.73180128983843], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000], -14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000, 3]], -14.326336181730264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 7]], -14.172185501903007`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000], -14.038654109278484`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 9]], -13.9208710736221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000], -13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 3]], -12.716898269296165`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000], -12.429216196844383`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000], -12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000, 3]], -12.02375108873622], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 7]], -11.86960040890896], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000], -11.736069016284437`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 9]], -11.618285980628055`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000000], 14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000000], 14.914122846632385`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000000], 15.201804919084164`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000000], 15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000000], 15.60727002719233], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000000], 15.761420707019587`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000000], 15.89495209964411], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000000], 16.012735135300492`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 
      2.302585092994046}, {-23.62998910330235, 10.77811001390968}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) = 1 nm, \
\\!\\(\\*StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]\\) = 100 nm\"", 
       "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) = 10 nm, \
\\!\\(\\*StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]\\) = 100 nm\"", 
       "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) = 1 nm, \
\\!\\(\\*StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]\\) = 250 nm\"", 
       "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) = 10 nm, \
\\!\\(\\*StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]\\) = 250 nm\"", 
       "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) = 10 nm, \
\\!\\(\\*StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]\\) = 500 nm\""}, 
      "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[1]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.8]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.8]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #5}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.8`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.6`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.4`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.2`", "]"}]}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
               "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.9071453651253653`*^9, 3.9071454342494745`*^9, 
  3.9071455824333344`*^9, 3.9071464614646697`*^9, 3.9071466810759764`*^9},
 CellLabel->"Out[84]=",ExpressionUUID->"f66cb466-19c1-4fca-88d4-714e8196aae4"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Manuscript \
SAXS\\\\SAXS analysis\\\\FormFactors_Monodisperse_Dimensions.pdf\"\>"], \
"Output",
 CellChangeTimes->{3.9071453651253653`*^9, 3.9071454342494745`*^9, 
  3.9071455824333344`*^9, 3.9071464614646697`*^9, 3.90714668473218*^9},
 CellLabel->"Out[85]=",ExpressionUUID->"788e6efd-fa91-4098-b959-64fc011c4875"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Fixed", " ", "polydispersity", " ", "of", " ", "50", "%", " ", "in", " ",
      "all", " ", "dimensions"}], ",", " ", 
    RowBox[{"varying", " ", "sizes"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"plotFormFactors", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"calculateIntensitiesLR", "[", 
          RowBox[{
           RowBox[{"EstimateMu", "[", 
            RowBox[{"1", ",", ".5"}], "]"}], ",", 
           RowBox[{"EstimateSigma", "[", 
            RowBox[{"1", ",", ".5"}], "]"}], ",", 
           RowBox[{"EstimateMu", "[", 
            RowBox[{"100", ",", "50"}], "]"}], ",", 
           RowBox[{"EstimateSigma", "[", 
            RowBox[{"100", ",", "50"}], "]"}]}], "]"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
        RowBox[{"(*", " ", 
         RowBox[{"Shift", " ", "in", " ", "y", " ", "direction"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"calculateIntensitiesLR", "[", 
          RowBox[{
           RowBox[{"EstimateMu", "[", 
            RowBox[{"10", ",", "5"}], "]"}], ",", 
           RowBox[{"EstimateSigma", "[", 
            RowBox[{"10", ",", "5"}], "]"}], ",", 
           RowBox[{"EstimateMu", "[", 
            RowBox[{"100", ",", "50"}], "]"}], ",", 
           RowBox[{"EstimateSigma", "[", 
            RowBox[{"100", ",", "50"}], "]"}]}], "]"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"calculateIntensitiesLR", "[", 
          RowBox[{
           RowBox[{"EstimateMu", "[", 
            RowBox[{"1", ",", ".5"}], "]"}], ",", 
           RowBox[{"EstimateSigma", "[", 
            RowBox[{"1", ",", ".5"}], "]"}], ",", 
           RowBox[{"EstimateMu", "[", 
            RowBox[{"250", ",", "125"}], "]"}], ",", 
           RowBox[{"EstimateSigma", "[", 
            RowBox[{"250", ",", "125"}], "]"}]}], "]"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "400"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"calculateIntensitiesLR", "[", 
          RowBox[{
           RowBox[{"EstimateMu", "[", 
            RowBox[{"10", ",", "5"}], "]"}], ",", 
           RowBox[{"EstimateSigma", "[", 
            RowBox[{"10", ",", "5"}], "]"}], ",", 
           RowBox[{"EstimateMu", "[", 
            RowBox[{"250", ",", "125"}], "]"}], ",", 
           RowBox[{"EstimateSigma", "[", 
            RowBox[{"250", ",", "125"}], "]"}]}], "]"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "3000"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"calculateIntensitiesLR", "[", 
          RowBox[{
           RowBox[{"EstimateMu", "[", 
            RowBox[{"10", ",", "5"}], "]"}], ",", 
           RowBox[{"EstimateSigma", "[", 
            RowBox[{"10", ",", "5"}], "]"}], ",", 
           RowBox[{"EstimateMu", "[", 
            RowBox[{"500", ",", "250"}], "]"}], ",", 
           RowBox[{"EstimateSigma", "[", 
            RowBox[{"500", ",", "250"}], "]"}]}], "]"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "50000"}], "}"}]}], "}"}]}]}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "3"}]}], ",", " ", 
           RowBox[{"10", "^", "1"}]}], "}"}], ",", "Automatic"}], "}"}]}], 
      ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"{", " ", 
        RowBox[{
         RowBox[{"10", "^", 
          RowBox[{"-", "10"}]}], ",", 
         RowBox[{"10", "^", "4"}]}], "}"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks2", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"P\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"(\
\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\)\!\(\*\
StyleBox[\")\",FontSlant->\"Italic\"]\)\>\"", ",", " ", "None"}], "}"}], ",", 
         
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"PlotStyle", "->", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"GrayLevel", "[", "0", "]"}], ",", " ", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", 
             "Automatic"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"GrayLevel", "[", "0.2", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
             RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", 
             "Automatic"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"GrayLevel", "[", "0.4", "]"}], ",", " ", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", 
             "Automatic"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", " ", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"GrayLevel", "[", "0.8", "]"}], ",", " ", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
            "}"}]}], "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", 
           ",", " ", 
           RowBox[{"Opacity", "[", "1", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", 
           ",", " ", 
           RowBox[{"Opacity", "[", "0.8", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", 
           ",", " ", 
           RowBox[{"Opacity", "[", "0.6", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", 
           " ", 
           RowBox[{"Opacity", "[", "0.4", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", 
           " ", 
           RowBox[{"Opacity", "[", "0.2", "]"}]}], "}"}]}], "}"}]}], ",", " ",
       "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 1 nm, \
\!\(\*StyleBox[\"R\",FontSlant->\"Italic\"]\) = 100 nm\>\"", ",", " ", 
         "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 10 nm, \
\!\(\*StyleBox[\"R\",FontSlant->\"Italic\"]\) = 100 nm\>\"", ",", " ", 
         "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 1 nm, \
\!\(\*StyleBox[\"R\",FontSlant->\"Italic\"]\) = 250 nm\>\"", ",", "  ", 
         "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 10 nm, \
\!\(\*StyleBox[\"R\",FontSlant->\"Italic\"]\) = 250 nm\>\"", ",", "  ", 
         "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 10 nm, \
\!\(\*StyleBox[\"R\",FontSlant->\"Italic\"]\) = 500 nm\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", 
       RowBox[{"{", "Black", "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<FormFactors_Polydisperse_Dimensions.pdf\>\""}], "}"}], "]"}], 
     ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotFormFactors", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.90714565731478*^9, 3.907145811265035*^9}, {
  3.9071465345815744`*^9, 3.907146614985768*^9}},
 CellLabel->"In[82]:=",ExpressionUUID->"9f706ecb-10fe-4604-b12c-bc20d76b379b"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[1]], 
        LineBox[CompressedData["
1:eJw1lglcjPkfx6fpPqbmnmammebovhRicz3Zdt0RSVGqjRw5OvzT5o6skmWt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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.8]], 
        LineBox[CompressedData["
1:eJw1lgs4VPkbx88c434bY8ZcjGEw7jJIrW3rdzZt2+1furlHKdUWSf1tqVba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         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.6]], 
        LineBox[CompressedData["
1:eJw1lglYjWkbx0/75tTZ33NO6+m0CTGyR8+TBi2ytJtUZBvUl4aJrDXaaOgz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         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.4]], 
        LineBox[CompressedData["
1:eJw1lgk4lGsbx8fYl9GYxZj1NRgHWaqj7aiep+1rU7aiKOTQ+TpK1HFEJVpp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         "]]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.2]], 
        LineBox[CompressedData["
1:eJw1lgdUk9cbxsOegSQkZAeymO5ZXPcqtBSpgqIiDnCgWAFFqGWoVSy4KlpF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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.907755278982122, -22.147992135345927`}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"P\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\
StyleBox[\\\"(\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\"q\\\",\
FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\")\\\",FontSlant->\\\"\
Italic\\\"]\\)\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> {
       GrayLevel[0]}, FrameTicks -> {{{{
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "10"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           
           TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           
           TemplateBox[{"10", "6"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000], -230.25850929940458`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000], -225.65333911341648`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000], -221.04816892742838`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000], -216.4429987414403], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000], -211.8378285554522], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000], -207.2326583694641], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000], -202.62748818347603`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000], -198.02231799748793`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000], -193.41714781149983`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000], -188.81197762551176`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000], -184.20680743952366`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000], -179.60163725353556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000], -174.99646706754748`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000], -170.39129688155938`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000], -165.78612669557128`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000], -161.1809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000], -156.5757863235951], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0], -151.970616137607], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000000000000000000000000000]\
, -147.36544595161894`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000], \
-142.76027576563084`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000000000000000000000000000], \
-138.15510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000000000000000000000], \
-133.54993539365464`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000], \
-128.94476520766656`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000000000000000000000], \
-124.33959502167846`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000000000000000], \
-119.73442483569038`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000], \
-115.12925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000000000000000], \
-110.52408446371419`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000000000], \
-105.9189142777261], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000], \
-101.31374409173802`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000000000], -96.70857390574992], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000], -92.10340371976183], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000], -87.49823353377374], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000], -82.89306334778564], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000], -78.28789316179756], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000000000000], -73.68272297580947], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000000000000000000000], -69.07755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000000000000000000], -64.47238260383328], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000000], -59.86721241784519], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000000000000000], -55.262042231857095`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000000000000], -50.65687204586901], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000], -46.051701859880914`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000000000], -41.44653167389282], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000000], -36.841361487904734`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000], -32.23619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000], -27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000], 18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000], 23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000], 27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000], 32.23619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000], 36.841361487904734`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000], 41.44653167389282], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000], 46.051701859880914`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000], 50.65687204586901], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000], 55.262042231857095`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000], 59.86721241784519], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000], 64.47238260383328], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000], 69.07755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000000000], 73.68272297580947], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000], 78.28789316179756], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000000000], 82.89306334778564], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000000000000000], 87.49823353377374], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000], 92.10340371976183], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000000000000000], 
           96.70857390574992], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000000000000000000000], 
           101.31374409173802`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000], 
           105.9189142777261], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000000000000000000000], 
           110.52408446371419`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000000000000000000000000000], 
           115.12925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000000000], 
           119.73442483569038`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000000000000000000000000000], 
           124.33959502167846`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000000000000000000000000000000000], 
           128.94476520766656`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000000000000000], 
           133.54993539365464`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000000000000000000000000000000000],
            138.15510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000000], -22.33270374938051], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 3]], -21.927238641272346`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000000], -21.639556568820566`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000000], -21.416413017506358`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000000, 3]], -21.234091460712403`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 7]], -21.079940780885142`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000000], -20.94640938826062], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 9]], -20.82862635260424], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000000], -20.72326583694641], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000000], -20.030118656386467`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 3]], -19.624653548278303`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000000], -19.33697147582652], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000000], -19.11382792451231], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000000, 3]], -18.931506367718356`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 7]], -18.7773556878911], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000000], -18.643824295266576`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 9]], -18.526041259610192`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000], -17.72753356339242], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 3]], -17.322068455284256`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000], -17.034386382832476`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000], -16.811242831518264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000, 3]], -16.62892127472431], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 7]], -16.474770594897052`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000], -16.34123920227253], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 9]], -16.223456166616145`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000], -16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000], -15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 3]], -15.01948336229021], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000], -14.73180128983843], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000], -14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000, 3]], -14.326336181730264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 7]], -14.172185501903007`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000], -14.038654109278484`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 9]], -13.9208710736221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000], -13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 3]], -12.716898269296165`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000], -12.429216196844383`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000], -12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000, 3]], -12.02375108873622], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 7]], -11.86960040890896], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000], -11.736069016284437`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 9]], -11.618285980628055`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000000], 14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000000], 14.914122846632385`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000000], 15.201804919084164`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000000], 15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000000], 15.60727002719233], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000000], 15.761420707019587`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000000], 15.89495209964411], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000000], 16.012735135300492`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000], -20.72326583694641], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000], -16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000000], -22.33270374938051], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 3]], -21.927238641272346`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000000], -21.639556568820566`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000000], -21.416413017506358`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000000, 3]], -21.234091460712403`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 7]], -21.079940780885142`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000000], -20.94640938826062], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 9]], -20.82862635260424], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000000], -20.72326583694641], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000000], -20.030118656386467`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 3]], -19.624653548278303`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000000], -19.33697147582652], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000000], -19.11382792451231], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000000, 3]], -18.931506367718356`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 7]], -18.7773556878911], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000000], -18.643824295266576`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 9]], -18.526041259610192`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000], -17.72753356339242], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 3]], -17.322068455284256`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000], -17.034386382832476`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000], -16.811242831518264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000, 3]], -16.62892127472431], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 7]], -16.474770594897052`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000], -16.34123920227253], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 9]], -16.223456166616145`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000], -16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000], -15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 3]], -15.01948336229021], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000], -14.73180128983843], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000], -14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000, 3]], -14.326336181730264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 7]], -14.172185501903007`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000], -14.038654109278484`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 9]], -13.9208710736221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000], -13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 3]], -12.716898269296165`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000], -12.429216196844383`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000], -12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000, 3]], -12.02375108873622], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 7]], -11.86960040890896], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000], -11.736069016284437`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 9]], -11.618285980628055`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000000], 14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000000], 14.914122846632385`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000000], 15.201804919084164`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000000], 15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000000], 15.60727002719233], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000000], 15.761420707019587`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000000], 15.89495209964411], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000000], 16.012735135300492`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 
      2.302585092994046}, {-22.147992135345927`, 10.642979238542843`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) = 1 nm, \
\\!\\(\\*StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]\\) = 100 nm\"", 
       "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) = 10 nm, \
\\!\\(\\*StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]\\) = 100 nm\"", 
       "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) = 1 nm, \
\\!\\(\\*StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]\\) = 250 nm\"", 
       "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) = 10 nm, \
\\!\\(\\*StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]\\) = 250 nm\"", 
       "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) = 10 nm, \
\\!\\(\\*StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]\\) = 500 nm\""}, 
      "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[1]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.8]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.8]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #5}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.8`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.6`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.4`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.2`", "]"}]}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
               "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.9071458269152193`*^9, {3.907146566444562*^9, 3.907146617490886*^9}},
 CellLabel->"Out[82]=",ExpressionUUID->"2c0faa41-288c-4731-9ff6-2629da5eb8ff"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Manuscript \
SAXS\\\\SAXS analysis\\\\FormFactors_Polydisperse_Dimensions.pdf\"\>"], \
"Output",
 CellChangeTimes->{
  3.9071458269152193`*^9, {3.907146566444562*^9, 3.9071466196896176`*^9}},
 CellLabel->"Out[83]=",ExpressionUUID->"1fb078dd-25ed-49bd-8f01-adc005edc6bb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"plotSlopes", " ", "=", " ", 
  RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"1", ",", ".5"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"1", ",", ".5"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"100", ",", "50"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"100", ",", "50"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"Shift", " ", "in", " ", "y", " ", "direction"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"100", ",", "50"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"100", ",", "50"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"1", ",", ".5"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"1", ",", ".5"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "125"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "125"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "125"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "125"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"500", ",", "250"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"500", ",", "250"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"10", "^", 
          RowBox[{"-", "3"}]}], ",", " ", 
         RowBox[{"10", "^", "1"}]}], "}"}], ",", "Automatic"}], "}"}]}], ",", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{"{", " ", 
      RowBox[{
       RowBox[{"10", "^", 
        RowBox[{"-", "10"}]}], ",", 
       RowBox[{"10", "^", "4"}]}], "}"}], " ", "*)"}], "\[IndentingNewLine]", 
    
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
      " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
      "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GrayLevel", "[", "0", "]"}], ",", " ", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}],
            "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GrayLevel", "[", "0.2", "]"}], ",", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}],
            "}"}], ","}], "*)"}], 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.4", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.8", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
          "}"}]}], "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"PlotStyle", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "1", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "0.8", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "0.6", "]"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", " ", 
         RowBox[{"Opacity", "[", "0.4", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", " ", 
         RowBox[{"Opacity", "[", "0.2", "]"}]}], "}"}]}], "}"}]}], ",", " ", 
    "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 1 nm, \
\!\(\*StyleBox[\"R\",FontSlant->\"Italic\"]\) = 100 nm\>\"", ",", " ", 
       "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 10 nm, \
\!\(\*StyleBox[\"R\",FontSlant->\"Italic\"]\) = 100 nm\>\"", ",", " ", 
       "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 1 nm, \
\!\(\*StyleBox[\"R\",FontSlant->\"Italic\"]\) = 250 nm\>\"", ",", "  ", 
       "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 10 nm, \
\!\(\*StyleBox[\"R\",FontSlant->\"Italic\"]\) = 250 nm\>\"", ",", "  ", 
       "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 10 nm, \
\!\(\*StyleBox[\"R\",FontSlant->\"Italic\"]\) = 500 nm\>\""}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
      "\"\<FormFactorsSlopes_Polydisperse_Dimensions.pdf\>\""}], "}"}], "]"}],
    ",", 
   RowBox[{"Show", "[", 
    RowBox[{"plotSlopes", ",", " ", 
     RowBox[{"ImageSize", " ", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"8", " ", "cm"}], ",", " ", 
        RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9071458530672703`*^9, 3.9071459604259977`*^9}, {
  3.9071459913173695`*^9, 3.9071459987269588`*^9}, {3.907146067717845*^9, 
  3.9071460952455072`*^9}},
 CellLabel->"In[70]:=",ExpressionUUID->"6b2ad393-929f-4b47-9b88-84035511f772"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[1]], 
        LineBox[CompressedData["
1:eJw1lXk0VP8bx68xxs4MwzC2iBJFCcWX7ogWWQqJUpS0L5L6WSMlJZWylP2b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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.8]], 
        LineBox[CompressedData["
1:eJw1lXk4VWsbxrd5ttfe5m1WiiYdogxZjgYayBipTEmUDpHITMrUaCiUTeaP
JJXMvU8ZkoijbBFCEnHIPPPtc63jj3Wt677uNbzree/7t+Qd3c3OspJIpHrm
8e+ZtK07bDZKErarajcadd1FEO5j+dFGEuxurNE8fGJRSDdFKXsr09fIC/xD
Mx7hGk8WA5dp0Fbk2yemeB+t3T7YZNlEA/tHVsdndRMR+tmbup1Og9J71won
o5NRkJ6/J4c7DeoYd21jBF